use crate::ast::Local;
use crate::compiler::Compiler;
use crate::vm::OpCode;

impl Compiler {
    pub(super) fn compile_local(&mut self, local: Local) {
        let mut exps = local.exps.into_iter();

        for (name, attr) in local.vars.into_iter() {
            let dst = self.scopes.declare_local(name, attr);

            if let Some(exp) = exps.next() {
                self.compile_exp(exp);
                self.emit(OpCode::PopLocal(dst));
            }
        }
    }
}
