use crate::ast::Chunk;
use crate::compiler::{Compiler, ScopeType};

impl Compiler {
    pub(super) fn compile_chunk(&mut self, chunk: Chunk) {
        self.scope_enter(ScopeType::Light);

        self.compile_block(chunk.block);

        self.scope_leave();
    }
}
