use crate::ast::Block;
use crate::compiler::Compiler;
use crate::vm::OpCode;

impl Compiler {
    pub(super) fn compile_block(&mut self, block: Block) {
        for stat in block.stats {
            self.compile_stat(stat);
        }

        if let Some(exps) = block.ret {
            let len = exps.len();
            for exp in exps.into_iter() {
                self.compile_exp(exp);
            }
            self.emit(OpCode::Combine(len));
            self.emit(OpCode::Return);
        }
    }
}
