use crate::ast::{Ass, Attr, Var};
use crate::compiler::Compiler;
use crate::vm::{OpCode, Value};

impl Compiler {
    pub(super) fn compile_ass(&mut self, ass: Ass) {
        // Delay all assignments until end, save here
        let mut end = Vec::new();

        let exp_count = ass.exps.len();
        for exp in ass.exps.into_iter() {
            self.compile_exp(exp);
        }
        self.emit(OpCode::Combine(exp_count));
        let local = self.scopes.declare_local("--ass".to_string(), None);
        self.emit(OpCode::PopLocal(local));

        for (ind, var) in ass.vars.into_iter().enumerate() {
            self.emit(OpCode::PushLocalMult(local, ind));

            match var {
                Var::Name(name) => match self.scopes.get(&name) {
                    Some((dst, attr)) => {
                        if matches!(attr, Some(Attr::Const)) {
                            panic!("cannot assign to const");
                        }
                        end.push(OpCode::PopLocal(dst))
                    }
                    None => {
                        self.emit(OpCode::PushLit(Value::String(name)));
                        self.emit(OpCode::PushEnv);
                        end.push(OpCode::SetTbl);
                    }
                },
                Var::Index(prefix, exp) => {
                    self.compile_exp(exp);
                    self.compile_prefix_exp(prefix);
                    end.push(OpCode::SetTbl);
                }
            };
        }

        self.emit_all(end.into_iter().rev());
    }
}
