use crate::ast::{Block, Exp, Parser};
use crate::error::Result;
use crate::token::Token;

/// ```test
/// stat ::= while exp do block end
/// ```
pub struct While {
    pub cond: Box<Exp>,
    pub block: Box<Block>,
}

impl<'a> Parser<'a> {
    pub(super) fn parse_while(&mut self) -> Result<While> {
        if !matches!(self.tokens.next(), Token::While) {
            panic!()
        }

        let cond = Box::new(self.parse_exp()?);

        if !matches!(self.tokens.next(), Token::Do) {
            panic!()
        }
        let block = Box::new(self.parse_block()?);
        if !matches!(self.tokens.next(), Token::End) {
            panic!()
        }

        Ok(While { cond, block })
    }
}
