use crate::ast::{Block, Exp, Parser};
use crate::error::Result;
use crate::token::Token;

/// ```text
/// stat ::= repeat block until exp
/// ```
pub struct Repeat {
    pub block: Box<Block>,
    pub cond: Box<Exp>,
}

impl<'a> Parser<'a> {
    pub(super) fn parse_repeat(&mut self) -> Result<Repeat> {
        if !matches!(self.tokens.next(), Token::Repeat) {
            panic!()
        }

        let block = Box::new(self.parse_block()?);

        if !matches!(self.tokens.next(), Token::Until) {
            panic!()
        }

        let cond = Box::new(self.parse_exp()?);

        Ok(Repeat { block, cond })
    }
}
