use crate::error::Result;
use crate::token::Tokenizer;

mod assignment;
mod block;
mod chunk;
mod expression;
mod r#for;
mod function;
mod r#if;
mod local;
mod prefix_exp;
mod repeat;
mod statement;
mod table;
mod r#while;

pub use assignment::{Ass, Var};
pub use block::Block;
pub use chunk::Chunk;
pub use expression::Exp;
pub use function::Func;
pub use local::{Attr, Local};
pub use prefix_exp::PrefixExp;
pub use r#for::{For, ForGen, ForNum};
pub use r#if::If;
pub use r#while::While;
pub use repeat::Repeat;
pub use statement::Stat;
pub use table::TableField;

/// Parser to parse Lua code into a syntax tree.
/// Entry point for parsing the Lua code is at [`Chunk`].
pub struct Parser<'a> {
    tokens: Tokenizer<'a>,
}

impl<'a> Parser<'a> {
    pub fn parse(input: &'a str) -> Result<Chunk> {
        let mut parser = Self {
            tokens: Tokenizer::read(input)?,
        };

        parser.parse_chunk()
    }
}
