use crate::ast::{Block, Parser};
use crate::error::Result;

/// ```text
/// chunk ::= block
/// ```
pub struct Chunk {
    pub block: Block,
}

impl<'a> Parser<'a> {
    pub(super) fn parse_chunk(&mut self) -> Result<Chunk> {
        Ok(Chunk {
            block: self.parse_block()?,
        })
    }
}
