use crate::ast::{Exp, Parser, Stat};
use crate::error::Result;
use crate::token::Token;

/// ```text
/// block ::= {stat} [retstat]
/// retstat ::= return [explist] [‘;’]
/// ```
pub struct Block {
    pub stats: Vec<Stat>,
    pub ret: Option<Vec<Exp>>,
}

impl<'a> Parser<'a> {
    pub(super) fn parse_block(&mut self) -> Result<Block> {
        let mut stats = Vec::new();
        let mut ret = None;

        loop {
            match self.tokens.peek() {
                Token::Eof | Token::Elseif | Token::Else | Token::Until | Token::End => break,
                Token::Return => {
                    self.tokens.next();

                    // Skip parsing expressions if there are none
                    if let Token::End = self.tokens.peek() {
                        ret = Some(vec![]);
                        break;
                    }

                    let mut exps = vec![self.parse_exp()?];
                    while let Token::Comma = self.tokens.peek() {
                        self.tokens.next();
                        exps.push(self.parse_exp()?);
                    }
                    ret = Some(exps);
                    break;
                }
                _ => stats.push(self.parse_stat()?),
            }
        }

        Ok(Block { stats, ret })
    }
}
