
use crate::*;

pub trait Sealed {}
impl<T> Sealed for [T] {}

impl<T> AsLtPtr for [T] {
    type Target = T;
    fn as_lt_ptr(&self) -> ConstLtPtr<'_, T> {
        unsafe { ConstLtPtr::from_raw(self.as_ptr()) }
    }
}

impl<T> AsMutLtPtr for [T] {
    fn as_mut_lt_ptr(&mut self) -> MutLtPtr<'_, T> {
        unsafe { MutLtPtr::from_raw(self.as_mut_ptr()) }
    }
}

impl<T> SliceExt<T> for [T] {
    fn as_lt_ptr_range(&self) -> Range<ConstLtPtr<'_, T>> {
        let Range { start, end } = self.as_ptr_range();
        unsafe {
            Range {
                start: ConstLtPtr::from_raw(start),
                end: ConstLtPtr::from_raw(end),
            }
        }
    }

    fn as_mut_lt_ptr_range(&mut self) -> Range<MutLtPtr<'_, T>> {
        let Range { start, end } = self.as_mut_ptr_range();
        unsafe {
            Range {
                start: MutLtPtr::from_raw(start),
                end: MutLtPtr::from_raw(end),
            }
        }
    }
}
