
//use core::ops::{Deref, DerefMut};
use core::panic::{RefUnwindSafe, UnwindSafe};

use crate::*;

// maybe we shouldn't have Deref? we want to make it hard to fuck things up.

//impl<'a, T: ?Sized> Deref for ConstLtPtr<'a, T> {
//    type Target = *const T;
//    fn deref(&self) -> &*const T {
//        &self.raw
//    }
//}
//
//impl<'a, T: ?Sized> DerefMut for ConstLtPtr<'a, T> {
//    fn deref_mut(&mut self) -> &mut *const T {
//        &mut self.raw
//    }
//}
//
//impl<'a, T: ?Sized> Deref for MutLtPtr<'a, T> {
//    type Target = *mut T;
//    fn deref(&self) -> &*mut T {
//        &self.raw
//    }
//}
//
//impl<'a, T: ?Sized> DerefMut for MutLtPtr<'a, T> {
//    fn deref_mut(&mut self) -> &mut *mut T {
//        &mut self.raw
//    }
//}

// *mut T are UnwindSafe, so ours should be too.
impl<'a, T: RefUnwindSafe + ?Sized> UnwindSafe for MutLtPtr<'a, T> {}

impl<'a, T: ?Sized> Copy for ConstLtPtr<'a, T> {}
impl<'a, T: ?Sized> Clone for ConstLtPtr<'a, T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}

impl<'a, T: ?Sized> core::fmt::Debug for ConstLtPtr<'a, T> {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        core::fmt::Debug::fmt(&self.raw, f)
    }
}

impl<'a, T: ?Sized> core::fmt::Pointer for ConstLtPtr<'a, T> {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        core::fmt::Pointer::fmt(&self.raw, f)
    }
}

impl<'a, T: ?Sized> core::hash::Hash for ConstLtPtr<'a, T> {
    #[inline]
    fn hash<H: core::hash::Hasher>(&self, state: &mut H) {
        core::hash::Hash::hash(&self.raw, state)
    }
}

impl<'a, T: ?Sized> core::cmp::Ord for ConstLtPtr<'a, T> {
    #[inline]
    fn cmp(&self, other: &Self) -> core::cmp::Ordering {
        core::cmp::Ord::cmp(&self.raw, &other.raw)
    }
}

impl<'a, T: ?Sized> core::cmp::Eq for ConstLtPtr<'a, T> {}
impl<'a, T: ?Sized> core::cmp::PartialEq for ConstLtPtr<'a, T> {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        core::cmp::PartialEq::eq(&self.raw, &other.raw)
    }
}

impl<'a, T: ?Sized> core::cmp::PartialOrd for ConstLtPtr<'a, T> {
    #[inline]
    fn partial_cmp(&self, other: &Self) -> Option<core::cmp::Ordering> {
        core::cmp::PartialOrd::partial_cmp(&self.raw, &other.raw)
    }

    #[inline]
    fn lt(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::lt(&self.raw, &other.raw)
    }

    #[inline]
    fn le(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::le(&self.raw, &other.raw)
    }

    #[inline]
    fn gt(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::gt(&self.raw, &other.raw)
    }

    #[inline]
    fn ge(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::ge(&self.raw, &other.raw)
    }
}

impl<'a, T: ?Sized> Copy for MutLtPtr<'a, T> {}
impl<'a, T: ?Sized> Clone for MutLtPtr<'a, T> {
    #[inline]
    fn clone(&self) -> Self {
        *self
    }
}

impl<'a, T: ?Sized> core::fmt::Debug for MutLtPtr<'a, T> {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        core::fmt::Debug::fmt(&self.raw, f)
    }
}

impl<'a, T: ?Sized> core::fmt::Pointer for MutLtPtr<'a, T> {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        core::fmt::Pointer::fmt(&self.raw, f)
    }
}

impl<'a, T: ?Sized> core::hash::Hash for MutLtPtr<'a, T> {
    #[inline]
    fn hash<H: core::hash::Hasher>(&self, state: &mut H) {
        core::hash::Hash::hash(&self.raw, state)
    }
}

impl<'a, T: ?Sized> core::cmp::Ord for MutLtPtr<'a, T> {
    #[inline]
    fn cmp(&self, other: &Self) -> core::cmp::Ordering {
        core::cmp::Ord::cmp(&self.raw, &other.raw)
    }
}

impl<'a, T: ?Sized> core::cmp::Eq for MutLtPtr<'a, T> {}
impl<'a, T: ?Sized> core::cmp::PartialEq for MutLtPtr<'a, T> {
    #[inline]
    fn eq(&self, other: &Self) -> bool {
        core::cmp::PartialEq::eq(&self.raw, &other.raw)
    }
}

impl<'a, T: ?Sized> core::cmp::PartialOrd for MutLtPtr<'a, T> {
    #[inline]
    fn partial_cmp(&self, other: &Self) -> Option<core::cmp::Ordering> {
        core::cmp::PartialOrd::partial_cmp(&self.raw, &other.raw)
    }

    #[inline]
    fn lt(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::lt(&self.raw, &other.raw)
    }

    #[inline]
    fn le(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::le(&self.raw, &other.raw)
    }

    #[inline]
    fn gt(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::gt(&self.raw, &other.raw)
    }

    #[inline]
    fn ge(&self, other: &Self) -> bool {
        core::cmp::PartialOrd::ge(&self.raw, &other.raw)
    }
}
