
use std::ffi::CStr;
use std::os::raw::c_char;

use crate::*;

impl AsLtPtr for CStr {
    type Target = c_char;

    /// Returns the inner pointer to this C string.
    ///
    /// The returned pointer points to a contiguous region of memory terminated
    /// with a 0 byte to represent the end of the string.
    #[inline]
    fn as_lt_ptr(&self) -> ConstLtPtr<'_, c_char> {
        unsafe { ConstLtPtr::from_raw(self.as_ptr()) }
    }
}
