//! Tests for PEC15 checksum algorithm
use crate::pec15::PEC15;

#[test]
fn test_pec15_two_bytes() {
    // STSCTRL command
    assert_eq!([0x8e, 0x4e], PEC15::calc(&[0x0, 0x19]));

    // CLRSCTRL command
    assert_eq!([0x5, 0x7c], PEC15::calc(&[0x0, 0x18]));

    // Cell Voltage register A
    assert_eq!([7, 194], PEC15::calc(&[0x0, 0x4]));
}

#[test]
fn test_pec15_multiple_bytes() {
    assert_eq!([0x37, 0x9e], PEC15::calc(&[0x32, 0x67, 0xF2, 0x1E, 0x5F, 0x24]));
    assert_eq!([0x98, 0x84], PEC15::calc(&[0xCD, 0x62, 0x11, 0x1F, 0x83, 0x24]));
    assert_eq!([0x1B, 0xE6], PEC15::calc(&[0xC9, 0x62, 0x7C, 0x1C, 0x1A, 0x21]));
}
