//! # Diesel Support
//!
//! Diesel support is included in this module. Moreover, to activate it, use
//! the embeded migrations (or write your own.) The schema is included from lib.

use super::User;
use crate::schema::*;
use crate::Permissions;
use diesel_migrations::embed_migrations;

embed_migrations!("migrations/");
pub mod migrations {
    pub use super::embedded_migrations::*;
}

/// This is the diesel version of a user, meaning it is not designed to be
/// worked with but rathre used as an intermediary between the databases
/// and the program.
#[derive(Clone, Debug, Hash, PartialEq, Eq, Ord, PartialOrd)]
#[cfg_attr(
    feature = "diesel-support",
    derive(Queryable, Insertable, Identifiable),
    primary_key(username),
    table_name = "login_users"
)]
pub struct DieselUser {
    /// This is then username / id of the user
    pub username: String,
    /// This is the password of the user.
    ///
    /// This is stores hashed with Argon2id.
    pub password: String,
    pub permissions: Permissions,
}

impl From<User> for DieselUser {
    fn from(them: User) -> Self {
        Self {
            username: them.username,
            password: them.password,
            permissions: them.permissions,
        }
    }
}

impl From<DieselUser> for User {
    fn from(them: DieselUser) -> Self {
        Self {
            username: them.username,
            password: them.password,
            permissions: them.permissions,
            logged_in: None,
            expire: None,
        }
    }
}
