# LPC845 PAC [![crates.io](https://img.shields.io/crates/v/lpc845-pac.svg)](https://crates.io/crates/lpc845-pac) [![Documentation](https://docs.rs/lpc845-pac/badge.svg)](https://docs.rs/lpc845-pac) [![Build Status](https://travis-ci.com/lpc-rs/lpc-pac.svg?branch=master)](https://travis-ci.com/lpc-rs/lpc-pac)

## Introduction

Low-level register mappings for the [NXP LPC845] family of ARM Cortex-M0+ microcontrollers, written in [Rust]. The code is generated automatically from the [SVD file] available from ARM, using [svd2rust].

The purpose of this crate is to give embedded programs or libraries written Rust access to the complete functionality of LPC845 MCUs.


## Usage

Add this to the `[dependencies]` section of your `Cargo.toml` to include rust-lpc845 in your Cargo project:

``` toml
lpc845-pac = "0.2"
```

This crate includes an optional `rt` feature that can be activated by adding this instead:

``` toml
lpc845-pac = { version = "0.2", features = ["rt"] }
```

The `rt` feature includes the [cortex-m-rt] crate and provides overridable interrupt handlers. Please refer to the [svd2rust documentation] for further details.

## Documentation

For specific information on the API, check out the **[API reference]**.

All code in this crate is automatically generated by [svd2rust], so check out the **[svd2rust documentation]** for more general information about how the API works.

In addition, the [LPC845 user manual] contains extensive documentation on how to work with the microcontroller.

## Status

This crate is complete and actively maintained, but not all parts of it have been tested. The experience so far has shown that the original SVD file has quite a few problems. It's likely there are still undetected bugs. Please [open an issue], if you find any problems. Known issues are tracked [on GitHub][list of open issues].

Another problem that we inherit from the SVD file is that some register and field names are very weird. Those seem to be generated from human-readable documentation, meaning they sometimes read like cut-off sentences.

At this point, there is no guarantee of API stability. This means that we reserve the right to make changes to the API, that might break existing programs when they upgrade.

## License

This project is open source software, licensed under the terms of the [Zero Clause BSD License][Zero Clause BSD License] (0BSD, for short). This basically means you can do anything with the software, without any restrictions, but you can't hold the authors liable for problems.

See [LICENSE] for full details.

## SVD file

You can get the svd file via the nxp sdk builder or via the readymade [keil
pack](https://mcuxpresso.nxp.com/cmsis_pack/repo/NXP.LPC845_DFP.11.0.0.pack)
(simply unpack it as a zip file).


**Supported by [Braun Robotics]**


[Rust]: https://www.rust-lang.org/
[NXP LPC845]: https://www.nxp.com/products/processors-and-microcontrollers/arm-based-processors-and-mcus/lpc-cortex-m-mcus/lpc800-series-cortex-m0-plus-mcus/low-cost-microcontrollers-mcus-based-on-arm-cortex-m0-plus-cores:LPC84X
[svd2rust]: https://crates.io/crates/svd2rust
[cortex-m-rt]: https://crates.io/crates/cortex-m-rt
[svd2rust documentation]: https://docs.rs/svd2rust
[API reference]: https://docs.rs/lpc845-pac
[LPC845 user manual]: https://www.nxp.com/docs/en/user-guide/UM11029.pdf
[open an issue]: https://github.com/lpc-rs/lpc-pac/issues/new
[list of open issues]: https://github.com/lpc-rs/lpc-pac/issues
[rustup]: https://rustup.rs/
[update script]: https://github.com/lpc-rs/lpc-pac//blob/master/lpc845/scripts/update.sh
[rustfmt]: https://crates.io/crates/rustfmt
[Zero Clause BSD License]: https://opensource.org/licenses/FPL-1.0.0
[LICENSE]: https://github.com/lpc-rs/blob/master/lpc-pac/lpc845/LICENSE
[Braun Robotics]: https://braun-robotics.com/
