# LPC82x PAC [![crates.io](https://img.shields.io/crates/v/lpc82x-pac.svg)](https://crates.io/crates/lpc82x-pac) [![Documentation](https://docs.rs/lpc82x-pac/badge.svg)](https://docs.rs/lpc82x-pac) [![Build Status](https://travis-ci.com/lpc-rs/lpc-pac.svg?branch=master)](https://travis-ci.com/lpc-rs/lpc-pac)

## Introduction

**This is a very low-level library. Most users should use [lpc82x-hal] instead.**

Low-level register mappings for the [NXP LPC82x] family of ARM Cortex-M0+ microcontrollers, written in [Rust]. The code is generated automatically from the [SVD file] available from ARM, using [svd2rust].

The purpose of this crate is to give embedded programs or libraries written Rust access to the complete functionality of LPC82x MCUs.

Please also check out [lpc82x-hal], a higher-level crate for interfacing with LPC82x microcontrollers.


## Usage

Add this to the `[dependencies]` section of your `Cargo.toml` to include `lpc82x-pac` in your Cargo project:

``` toml
lpc82x-pac = "0.7"
```

This crate includes an optional `rt` feature that can be activated by adding this instead:

``` toml
lpc82x-pac = { version = "0.7", features = ["rt"] }
```

The `rt` feature includes the [cortex-m-rt] crate and provides overridable interrupt handlers. Please refer to the [svd2rust documentation] for further details.

## Documentation

For specific information on the API, check out the **[API reference]**.

All code in this crate is automatically generated by [svd2rust], so check out the **[svd2rust documentation]** for more general information about how the API works.

In addition, the [LPC82x user manual] contains extensive documentation on how to work with the microcontroller.

## Status

This crate is complete and actively maintained, but not all parts of it have been tested. The experience so far has shown that the original SVD file has quite a few problems. It's likely there are still undetected bugs. Please [open an issue], if you find any problems. Known issues are tracked [on GitHub][list of open issues].

Another problem that we inherit from the SVD file is that some register and field names are very weird. Those seem to be generated from human-readable documentation, meaning they sometimes read like cut-off sentences.

At this point, there is no guarantee of API stability. This means that we reserve the right to make changes to the API, that might break existing programs when they upgrade.

## Update Procedure

The repository contains an [update script], that can be used to re-generate the source code. This script updates all required tools ([svd2rust] and [rustfmt]), downloads the [SVD file], applies various patches to it, and then re-generates the code.

The patches that are applied to the SVD file are relatively minimal, and are just intended to fix various problems with the file that otherwise would prevent code generation, or would lead to incorrect code being generated.


## License

This project is open source software, licensed under the terms of the [Zero Clause BSD License][Zero Clause BSD License] (0BSD, for short). This basically means you can do anything with the software, without any restrictions, but you can't hold the authors liable for problems.

See [LICENSE] for full details.


**Supported by [Braun Embedded]**


[Rust]: https://www.rust-lang.org/
[NXP LPC82x]: http://www.nxp.com/products/microcontrollers-and-processors/arm-based-processors-and-mcus/lpc-cortex-m-mcus/lpc800-series-cortex-m0-plus-mcus/low-cost-microcontrollers-mcus-based-on-arm-cortex-m0-plus-cores:LPC82X
[SVD file]: http://ds.arm.com/media/resources/db/chip/nxp/lpc824m201jdh20/LPC82x.svd
[svd2rust]: https://crates.io/crates/svd2rust
[lpc82x-hal]: https://crates.io/crates/lpc82x-hal
[cortex-m-rt]: https://crates.io/crates/cortex-m-rt
[svd2rust documentation]: https://docs.rs/svd2rust
[API reference]: https://docs.rs/lpc82x-pac
[LPC82x user manual]: https://www.nxp.com/docs/en/user-guide/UM10800.pdf
[open an issue]: https://github.com/lpc-rs/lpc-pac/issues/new
[list of open issues]: https://github.com/lpc-rs/lpc-pac/labels/crate%3A%20lpc82x-pac
[rustup]: https://rustup.rs/
[update script]: https://github.com/lpc-rs/lpc-pac/blob/master/lpc82x/scripts/update.sh
[rustfmt]: https://crates.io/crates/rustfmt
[Zero Clause BSD License]: https://opensource.org/licenses/FPL-1.0.0
[LICENSE]: https://github.com/lpc-rs/lpc-pac/blob/master/lpc82x/LICENSE
[Braun Embedded]: https://braun-embedded.com/
