#[doc = "Register `IRQCLR` writer"]
pub struct W(crate::W<IRQCLR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<IRQCLR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<IRQCLR_SPEC>> for W {
    fn from(writer: crate::W<IRQCLR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `INTREQCLR` writer - Writing 1 clears the corresponding bit in the IRQ0 register."]
pub struct INTREQCLR_W<'a> {
    w: &'a mut W,
}
impl<'a> INTREQCLR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff_ffff) | (value as u32 & 0xffff_ffff);
        self.w
    }
}
impl W {
    #[doc = "Bits 0:31 - Writing 1 clears the corresponding bit in the IRQ0 register."]
    #[inline(always)]
    pub fn intreqclr(&mut self) -> INTREQCLR_W {
        INTREQCLR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clear bits in IRQ0\n\nThis register you can [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [irqclr](index.html) module"]
pub struct IRQCLR_SPEC;
impl crate::RegisterSpec for IRQCLR_SPEC {
    type Ux = u32;
}
#[doc = "`write(|w| ..)` method takes [irqclr::W](W) writer structure"]
impl crate::Writable for IRQCLR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets IRQCLR to value 0"]
impl crate::Resettable for IRQCLR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
