#![doc = "Peripheral access API for LPC55S69_CM33_CORE0 microcontrollers (generated using svd2rust v0.18.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.18.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn WDT_BOD();
    fn DMA0();
    fn GINT0();
    fn GINT1();
    fn PIN_INT0();
    fn PIN_INT1();
    fn PIN_INT2();
    fn PIN_INT3();
    fn UTICK0();
    fn MRT0();
    fn CTIMER0();
    fn CTIMER1();
    fn SCT0();
    fn CTIMER3();
    fn FLEXCOMM0();
    fn FLEXCOMM1();
    fn FLEXCOMM2();
    fn FLEXCOMM3();
    fn FLEXCOMM4();
    fn FLEXCOMM5();
    fn FLEXCOMM6();
    fn FLEXCOMM7();
    fn ADC0();
    fn ACMP();
    fn USB0_NEEDCLK();
    fn USB0();
    fn RTC();
    fn MAILBOX();
    fn PIN_INT4();
    fn PIN_INT5();
    fn PIN_INT6();
    fn PIN_INT7();
    fn CTIMER2();
    fn CTIMER4();
    fn OS_EVENT();
    fn SDIO();
    fn USB1_PHY();
    fn USB1();
    fn USB1_NEEDCLK();
    fn SEC_HYPERVISOR_CALL();
    fn SEC_GPIO_INT0_IRQ0();
    fn SEC_GPIO_INT0_IRQ1();
    fn PLU();
    fn SEC_VIO();
    fn HASHCRYPT();
    fn CASER();
    fn PUF();
    fn PQ();
    fn DMA1();
    fn FLEXCOMM8();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 60] = [
    Vector { _handler: WDT_BOD },
    Vector { _handler: DMA0 },
    Vector { _handler: GINT0 },
    Vector { _handler: GINT1 },
    Vector { _handler: PIN_INT0 },
    Vector { _handler: PIN_INT1 },
    Vector { _handler: PIN_INT2 },
    Vector { _handler: PIN_INT3 },
    Vector { _handler: UTICK0 },
    Vector { _handler: MRT0 },
    Vector { _handler: CTIMER0 },
    Vector { _handler: CTIMER1 },
    Vector { _handler: SCT0 },
    Vector { _handler: CTIMER3 },
    Vector {
        _handler: FLEXCOMM0,
    },
    Vector {
        _handler: FLEXCOMM1,
    },
    Vector {
        _handler: FLEXCOMM2,
    },
    Vector {
        _handler: FLEXCOMM3,
    },
    Vector {
        _handler: FLEXCOMM4,
    },
    Vector {
        _handler: FLEXCOMM5,
    },
    Vector {
        _handler: FLEXCOMM6,
    },
    Vector {
        _handler: FLEXCOMM7,
    },
    Vector { _handler: ADC0 },
    Vector { _reserved: 0 },
    Vector { _handler: ACMP },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: USB0_NEEDCLK,
    },
    Vector { _handler: USB0 },
    Vector { _handler: RTC },
    Vector { _reserved: 0 },
    Vector { _handler: MAILBOX },
    Vector { _handler: PIN_INT4 },
    Vector { _handler: PIN_INT5 },
    Vector { _handler: PIN_INT6 },
    Vector { _handler: PIN_INT7 },
    Vector { _handler: CTIMER2 },
    Vector { _handler: CTIMER4 },
    Vector { _handler: OS_EVENT },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SDIO },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: USB1_PHY },
    Vector { _handler: USB1 },
    Vector {
        _handler: USB1_NEEDCLK,
    },
    Vector {
        _handler: SEC_HYPERVISOR_CALL,
    },
    Vector {
        _handler: SEC_GPIO_INT0_IRQ0,
    },
    Vector {
        _handler: SEC_GPIO_INT0_IRQ1,
    },
    Vector { _handler: PLU },
    Vector { _handler: SEC_VIO },
    Vector {
        _handler: HASHCRYPT,
    },
    Vector { _handler: CASER },
    Vector { _handler: PUF },
    Vector { _handler: PQ },
    Vector { _handler: DMA1 },
    Vector {
        _handler: FLEXCOMM8,
    },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - WDT_BOD"]
    WDT_BOD = 0,
    #[doc = "1 - DMA0"]
    DMA0 = 1,
    #[doc = "2 - GINT0"]
    GINT0 = 2,
    #[doc = "3 - GINT1"]
    GINT1 = 3,
    #[doc = "4 - PIN_INT0"]
    PIN_INT0 = 4,
    #[doc = "5 - PIN_INT1"]
    PIN_INT1 = 5,
    #[doc = "6 - PIN_INT2"]
    PIN_INT2 = 6,
    #[doc = "7 - PIN_INT3"]
    PIN_INT3 = 7,
    #[doc = "8 - UTICK0"]
    UTICK0 = 8,
    #[doc = "9 - MRT0"]
    MRT0 = 9,
    #[doc = "10 - CTIMER0"]
    CTIMER0 = 10,
    #[doc = "11 - CTIMER1"]
    CTIMER1 = 11,
    #[doc = "12 - SCT0"]
    SCT0 = 12,
    #[doc = "13 - CTIMER3"]
    CTIMER3 = 13,
    #[doc = "14 - FLEXCOMM0"]
    FLEXCOMM0 = 14,
    #[doc = "15 - FLEXCOMM1"]
    FLEXCOMM1 = 15,
    #[doc = "16 - FLEXCOMM2"]
    FLEXCOMM2 = 16,
    #[doc = "17 - FLEXCOMM3"]
    FLEXCOMM3 = 17,
    #[doc = "18 - FLEXCOMM4"]
    FLEXCOMM4 = 18,
    #[doc = "19 - FLEXCOMM5"]
    FLEXCOMM5 = 19,
    #[doc = "20 - FLEXCOMM6"]
    FLEXCOMM6 = 20,
    #[doc = "21 - FLEXCOMM7"]
    FLEXCOMM7 = 21,
    #[doc = "22 - ADC0"]
    ADC0 = 22,
    #[doc = "24 - ACMP"]
    ACMP = 24,
    #[doc = "27 - USB0_NEEDCLK"]
    USB0_NEEDCLK = 27,
    #[doc = "28 - USB0"]
    USB0 = 28,
    #[doc = "29 - RTC"]
    RTC = 29,
    #[doc = "31 - MAILBOX"]
    MAILBOX = 31,
    #[doc = "32 - PIN_INT4"]
    PIN_INT4 = 32,
    #[doc = "33 - PIN_INT5"]
    PIN_INT5 = 33,
    #[doc = "34 - PIN_INT6"]
    PIN_INT6 = 34,
    #[doc = "35 - PIN_INT7"]
    PIN_INT7 = 35,
    #[doc = "36 - CTIMER2"]
    CTIMER2 = 36,
    #[doc = "37 - CTIMER4"]
    CTIMER4 = 37,
    #[doc = "38 - OS_EVENT"]
    OS_EVENT = 38,
    #[doc = "42 - SDIO"]
    SDIO = 42,
    #[doc = "46 - USB1_PHY"]
    USB1_PHY = 46,
    #[doc = "47 - USB1"]
    USB1 = 47,
    #[doc = "48 - USB1_NEEDCLK"]
    USB1_NEEDCLK = 48,
    #[doc = "49 - SEC_HYPERVISOR_CALL"]
    SEC_HYPERVISOR_CALL = 49,
    #[doc = "50 - SEC_GPIO_INT0_IRQ0"]
    SEC_GPIO_INT0_IRQ0 = 50,
    #[doc = "51 - SEC_GPIO_INT0_IRQ1"]
    SEC_GPIO_INT0_IRQ1 = 51,
    #[doc = "52 - PLU"]
    PLU = 52,
    #[doc = "53 - SEC_VIO"]
    SEC_VIO = 53,
    #[doc = "54 - HASHCRYPT"]
    HASHCRYPT = 54,
    #[doc = "55 - CASER"]
    CASER = 55,
    #[doc = "56 - PUF"]
    PUF = 56,
    #[doc = "57 - PQ"]
    PQ = 57,
    #[doc = "58 - DMA1"]
    DMA1 = 58,
    #[doc = "59 - FLEXCOMM8"]
    FLEXCOMM8 = 59,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "FLASH_CFPA"]
pub struct FLASH_CFPA0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_CFPA0 {}
impl FLASH_CFPA0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_cfpa0::RegisterBlock = 0x0009_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_cfpa0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_CFPA0 {
    type Target = flash_cfpa0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_CFPA0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_CFPA0").finish()
    }
}
#[doc = "FLASH_CFPA"]
pub mod flash_cfpa0;
#[doc = "FLASH_CFPA"]
pub struct FLASH_CFPA_SCRATCH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_CFPA_SCRATCH {}
impl FLASH_CFPA_SCRATCH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_cfpa0::RegisterBlock = 0x0009_de00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_cfpa0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_CFPA_SCRATCH {
    type Target = flash_cfpa0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_CFPA_SCRATCH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_CFPA_SCRATCH").finish()
    }
}
#[doc = "FLASH_CFPA"]
pub struct FLASH_CFPA1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_CFPA1 {}
impl FLASH_CFPA1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_cfpa0::RegisterBlock = 0x0009_e200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_cfpa0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_CFPA1 {
    type Target = flash_cfpa0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_CFPA1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_CFPA1").finish()
    }
}
#[doc = "FLASH_CMPA"]
pub struct FLASH_CMPA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_CMPA {}
impl FLASH_CMPA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_cmpa::RegisterBlock = 0x0009_e400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_cmpa::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_CMPA {
    type Target = flash_cmpa::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_CMPA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_CMPA").finish()
    }
}
#[doc = "FLASH_CMPA"]
pub mod flash_cmpa;
#[doc = "FLASH_KEY_STORE"]
pub struct FLASH_KEY_STORE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_KEY_STORE {}
impl FLASH_KEY_STORE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_key_store::RegisterBlock = 0x0009_e600 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_key_store::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_KEY_STORE {
    type Target = flash_key_store::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_KEY_STORE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_KEY_STORE").finish()
    }
}
#[doc = "FLASH_KEY_STORE"]
pub mod flash_key_store;
#[doc = "SYSCON"]
pub struct SYSCON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCON {}
impl SYSCON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const syscon::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const syscon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCON {
    type Target = syscon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCON").finish()
    }
}
#[doc = "SYSCON"]
pub mod syscon;
#[doc = "I/O pin configuration (IOCON)"]
pub struct IOCON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOCON {}
impl IOCON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const iocon::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const iocon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOCON {
    type Target = iocon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOCON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOCON").finish()
    }
}
#[doc = "I/O pin configuration (IOCON)"]
pub mod iocon;
#[doc = "Group GPIO input interrupt (GINT0/1)"]
pub struct GINT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GINT0 {}
impl GINT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gint0::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gint0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GINT0 {
    type Target = gint0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GINT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GINT0").finish()
    }
}
#[doc = "Group GPIO input interrupt (GINT0/1)"]
pub mod gint0;
#[doc = "Group GPIO input interrupt (GINT0/1)"]
pub struct GINT1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GINT1 {}
impl GINT1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gint0::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gint0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GINT1 {
    type Target = gint0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GINT1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GINT1").finish()
    }
}
#[doc = "Pin interrupt and pattern match (PINT)"]
pub struct PINT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PINT {}
impl PINT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pint::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pint::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PINT {
    type Target = pint::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PINT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PINT").finish()
    }
}
#[doc = "Pin interrupt and pattern match (PINT)"]
pub mod pint;
#[doc = "Pin interrupt and pattern match (PINT)"]
pub struct SECPINT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SECPINT {}
impl SECPINT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pint::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pint::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SECPINT {
    type Target = pint::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SECPINT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SECPINT").finish()
    }
}
#[doc = "Input multiplexing (INPUT MUX)"]
pub struct INPUTMUX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for INPUTMUX {}
impl INPUTMUX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const inputmux::RegisterBlock = 0x4000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const inputmux::RegisterBlock {
        Self::PTR
    }
}
impl Deref for INPUTMUX {
    type Target = inputmux::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for INPUTMUX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("INPUTMUX").finish()
    }
}
#[doc = "Input multiplexing (INPUT MUX)"]
pub mod inputmux;
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER0 {}
impl CTIMER0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER0 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER0").finish()
    }
}
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub mod ctimer0;
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER1 {}
impl CTIMER1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER1 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER1").finish()
    }
}
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER2 {}
impl CTIMER2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER2 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER2").finish()
    }
}
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER3 {}
impl CTIMER3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4002_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER3 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER3").finish()
    }
}
#[doc = "Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER4 {}
impl CTIMER4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4002_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER4 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER4").finish()
    }
}
#[doc = "Windowed Watchdog Timer (WWDT)"]
pub struct WWDT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WWDT {}
impl WWDT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wwdt::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wwdt::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WWDT {
    type Target = wwdt::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WWDT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WWDT").finish()
    }
}
#[doc = "Windowed Watchdog Timer (WWDT)"]
pub mod wwdt;
#[doc = "Multi-Rate Timer (MRT)"]
pub struct MRT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MRT0 {}
impl MRT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mrt0::RegisterBlock = 0x4000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mrt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MRT0 {
    type Target = mrt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MRT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MRT0").finish()
    }
}
#[doc = "Multi-Rate Timer (MRT)"]
pub mod mrt0;
#[doc = "Micro-tick Timer (UTICK)"]
pub struct UTICK0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UTICK0 {}
impl UTICK0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const utick0::RegisterBlock = 0x4000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const utick0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UTICK0 {
    type Target = utick0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UTICK0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UTICK0").finish()
    }
}
#[doc = "Micro-tick Timer (UTICK)"]
pub mod utick0;
#[doc = "ANALOGCTRL"]
pub struct ANACTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ANACTRL {}
impl ANACTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const anactrl::RegisterBlock = 0x4001_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const anactrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ANACTRL {
    type Target = anactrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ANACTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ANACTRL").finish()
    }
}
#[doc = "ANALOGCTRL"]
pub mod anactrl;
#[doc = "PMC"]
pub struct PMC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PMC {}
impl PMC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pmc::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pmc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PMC {
    type Target = pmc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PMC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PMC").finish()
    }
}
#[doc = "PMC"]
pub mod pmc;
#[doc = "system controller"]
pub struct SYSCTL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCTL {}
impl SYSCTL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sysctl::RegisterBlock = 0x4002_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sysctl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCTL {
    type Target = sysctl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCTL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCTL").finish()
    }
}
#[doc = "system controller"]
pub mod sysctl;
#[doc = "Real-Time Clock (RTC)"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x4002_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "Real-Time Clock (RTC)"]
pub mod rtc;
#[doc = "Synchronous OS/Event timer with Wakeup Timer"]
pub struct OSTIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OSTIMER {}
impl OSTIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ostimer::RegisterBlock = 0x4002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ostimer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OSTIMER {
    type Target = ostimer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OSTIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OSTIMER").finish()
    }
}
#[doc = "Synchronous OS/Event timer with Wakeup Timer"]
pub mod ostimer;
#[doc = "FLASH"]
pub struct FLASH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH {}
impl FLASH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash::RegisterBlock = 0x4003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH {
    type Target = flash::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH").finish()
    }
}
#[doc = "FLASH"]
pub mod flash;
#[doc = "PRINCE"]
pub struct PRINCE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PRINCE {}
impl PRINCE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const prince::RegisterBlock = 0x4003_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const prince::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PRINCE {
    type Target = prince::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PRINCE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PRINCE").finish()
    }
}
#[doc = "PRINCE"]
pub mod prince;
#[doc = "Universal System Bus Physical Layer"]
pub struct USBPHY {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBPHY {}
impl USBPHY {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbphy::RegisterBlock = 0x4003_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbphy::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBPHY {
    type Target = usbphy::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBPHY {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBPHY").finish()
    }
}
#[doc = "Universal System Bus Physical Layer"]
pub mod usbphy;
#[doc = "RNG"]
pub struct RNG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RNG {}
impl RNG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rng::RegisterBlock = 0x4003_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RNG {
    type Target = rng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RNG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RNG").finish()
    }
}
#[doc = "RNG"]
pub mod rng;
#[doc = "PUFCTRL"]
pub struct PUF {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PUF {}
impl PUF {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const puf::RegisterBlock = 0x4003_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const puf::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PUF {
    type Target = puf::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PUF {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PUF").finish()
    }
}
#[doc = "PUFCTRL"]
pub mod puf;
#[doc = "LPC80X Programmable Logic Unit (PLU)"]
pub struct PLU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PLU {}
impl PLU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const plu::RegisterBlock = 0x4003_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const plu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PLU {
    type Target = plu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PLU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PLU").finish()
    }
}
#[doc = "LPC80X Programmable Logic Unit (PLU)"]
pub mod plu;
#[doc = "DMA controller"]
pub struct DMA0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA0 {}
impl DMA0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma0::RegisterBlock = 0x4008_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA0 {
    type Target = dma0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA0").finish()
    }
}
#[doc = "DMA controller"]
pub mod dma0;
#[doc = "DMA controller"]
pub struct DMA1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA1 {}
impl DMA1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma0::RegisterBlock = 0x400a_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA1 {
    type Target = dma0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA1").finish()
    }
}
#[doc = "SCTimer/PWM (SCT)"]
pub struct SCT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SCT0 {}
impl SCT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sct0::RegisterBlock = 0x4008_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sct0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SCT0 {
    type Target = sct0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SCT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SCT0").finish()
    }
}
#[doc = "SCTimer/PWM (SCT)"]
pub mod sct0;
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM0 {}
impl FLEXCOMM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM0 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM0").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub mod flexcomm0;
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM1 {}
impl FLEXCOMM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM1 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM1").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM2 {}
impl FLEXCOMM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM2 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM2").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM3 {}
impl FLEXCOMM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM3 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM3").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM4 {}
impl FLEXCOMM4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM4 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM4").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM5 {}
impl FLEXCOMM5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM5 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM5").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM6 {}
impl FLEXCOMM6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM6 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM6").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM7 {}
impl FLEXCOMM7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM7 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM7").finish()
    }
}
#[doc = "Flexcomm serial communication"]
pub struct FLEXCOMM8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM8 {}
impl FLEXCOMM8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM8 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM8").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C0 {}
impl I2C0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C0 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C0").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub mod i2c0;
#[doc = "I2C-bus interfaces"]
pub struct I2C1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C1 {}
impl I2C1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C1 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C1").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C2 {}
impl I2C2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C2 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C2").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C3 {}
impl I2C3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C3 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C3").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C4 {}
impl I2C4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C4 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C4").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C5 {}
impl I2C5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C5 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C5").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C6 {}
impl I2C6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C6 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C6").finish()
    }
}
#[doc = "I2C-bus interfaces"]
pub struct I2C7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C7 {}
impl I2C7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C7 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C7").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S0 {}
impl I2S0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S0 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S0").finish()
    }
}
#[doc = "I2S interface"]
pub mod i2s0;
#[doc = "I2S interface"]
pub struct I2S1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S1 {}
impl I2S1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S1 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S1").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S2 {}
impl I2S2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S2 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S2").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S3 {}
impl I2S3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S3 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S3").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S4 {}
impl I2S4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S4 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S4").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S5 {}
impl I2S5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S5 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S5").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S6 {}
impl I2S6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S6 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S6").finish()
    }
}
#[doc = "I2S interface"]
pub struct I2S7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S7 {}
impl I2S7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S7 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S7").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub mod spi0;
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI1 {}
impl SPI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI1 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI1").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI2 {}
impl SPI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI2 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI2").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI3 {}
impl SPI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI3 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI3").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI4 {}
impl SPI4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI4 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI4").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI5 {}
impl SPI5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI5 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI5").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI6 {}
impl SPI6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI6 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI6").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI7 {}
impl SPI7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI7 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI7").finish()
    }
}
#[doc = "Serial Peripheral Interfaces (SPI)"]
pub struct SPI8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI8 {}
impl SPI8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI8 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI8").finish()
    }
}
#[doc = "USARTs"]
pub struct USART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART0 {}
impl USART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART0 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART0").finish()
    }
}
#[doc = "USARTs"]
pub mod usart0;
#[doc = "USARTs"]
pub struct USART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART1 {}
impl USART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART1 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART1").finish()
    }
}
#[doc = "USARTs"]
pub struct USART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART2 {}
impl USART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART2 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART2").finish()
    }
}
#[doc = "USARTs"]
pub struct USART3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART3 {}
impl USART3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART3 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART3").finish()
    }
}
#[doc = "USARTs"]
pub struct USART4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART4 {}
impl USART4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART4 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART4").finish()
    }
}
#[doc = "USARTs"]
pub struct USART5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART5 {}
impl USART5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART5 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART5").finish()
    }
}
#[doc = "USARTs"]
pub struct USART6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART6 {}
impl USART6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART6 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART6").finish()
    }
}
#[doc = "USARTs"]
pub struct USART7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART7 {}
impl USART7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART7 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART7").finish()
    }
}
#[doc = "Mailbox"]
pub struct MAILBOX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MAILBOX {}
impl MAILBOX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mailbox::RegisterBlock = 0x4008_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mailbox::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MAILBOX {
    type Target = mailbox::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MAILBOX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MAILBOX").finish()
    }
}
#[doc = "Mailbox"]
pub mod mailbox;
#[doc = "General Purpose I/O (GPIO)"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x4008_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "General Purpose I/O (GPIO)"]
pub mod gpio;
#[doc = "USB1 High-speed Device Controller"]
pub struct USB1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB1 {}
impl USB1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb1::RegisterBlock = 0x4009_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB1 {
    type Target = usb1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB1").finish()
    }
}
#[doc = "USB1 High-speed Device Controller"]
pub mod usb1;
#[doc = "CRC engine"]
pub struct CRC_ENGINE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC_ENGINE {}
impl CRC_ENGINE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crc_engine::RegisterBlock = 0x4009_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crc_engine::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRC_ENGINE {
    type Target = crc_engine::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRC_ENGINE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRC_ENGINE").finish()
    }
}
#[doc = "CRC engine"]
pub mod crc_engine;
#[doc = "SDMMC"]
pub struct SDIF {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SDIF {}
impl SDIF {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sdif::RegisterBlock = 0x4009_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sdif::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SDIF {
    type Target = sdif::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SDIF {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SDIF").finish()
    }
}
#[doc = "SDMMC"]
pub mod sdif;
#[doc = "MCU Debugger Mailbox"]
pub struct DBGMAILBOX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DBGMAILBOX {}
impl DBGMAILBOX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dbgmailbox::RegisterBlock = 0x4009_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dbgmailbox::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DBGMAILBOX {
    type Target = dbgmailbox::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DBGMAILBOX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DBGMAILBOX").finish()
    }
}
#[doc = "MCU Debugger Mailbox"]
pub mod dbgmailbox;
#[doc = "ADC"]
pub struct ADC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC0 {}
impl ADC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc0::RegisterBlock = 0x400a_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC0 {
    type Target = adc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC0").finish()
    }
}
#[doc = "ADC"]
pub mod adc0;
#[doc = "USB0 Full-speed Host controller"]
pub struct USBFSH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBFSH {}
impl USBFSH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbfsh::RegisterBlock = 0x400a_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbfsh::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBFSH {
    type Target = usbfsh::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBFSH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBFSH").finish()
    }
}
#[doc = "USB0 Full-speed Host controller"]
pub mod usbfsh;
#[doc = "USB1 High-speed Host Controller"]
pub struct USBHSH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBHSH {}
impl USBHSH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbhsh::RegisterBlock = 0x400a_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbhsh::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBHSH {
    type Target = usbhsh::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBHSH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBHSH").finish()
    }
}
#[doc = "USB1 High-speed Host Controller"]
pub mod usbhsh;
#[doc = "Hash-Crypt peripheral"]
pub struct HASHCRYPT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HASHCRYPT {}
impl HASHCRYPT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hashcrypt::RegisterBlock = 0x400a_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hashcrypt::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HASHCRYPT {
    type Target = hashcrypt::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HASHCRYPT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HASHCRYPT").finish()
    }
}
#[doc = "Hash-Crypt peripheral"]
pub mod hashcrypt;
#[doc = "CASPER"]
pub struct CASPER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CASPER {}
impl CASPER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const casper::RegisterBlock = 0x400a_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const casper::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CASPER {
    type Target = casper::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CASPER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CASPER").finish()
    }
}
#[doc = "CASPER"]
pub mod casper;
#[doc = "Digital Signal Co-Processing companion to a Cortex-M v8M CPU core"]
pub struct POWERQUAD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for POWERQUAD {}
impl POWERQUAD {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const powerquad::RegisterBlock = 0x400a_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const powerquad::RegisterBlock {
        Self::PTR
    }
}
impl Deref for POWERQUAD {
    type Target = powerquad::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for POWERQUAD {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("POWERQUAD").finish()
    }
}
#[doc = "Digital Signal Co-Processing companion to a Cortex-M v8M CPU core"]
pub mod powerquad;
#[doc = "General Purpose I/O (GPIO)"]
pub struct SECGPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SECGPIO {}
impl SECGPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const secgpio::RegisterBlock = 0x400a_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const secgpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SECGPIO {
    type Target = secgpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SECGPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SECGPIO").finish()
    }
}
#[doc = "General Purpose I/O (GPIO)"]
pub mod secgpio;
#[doc = "AHB secure controller"]
pub struct AHB_SECURE_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AHB_SECURE_CTRL {}
impl AHB_SECURE_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ahb_secure_ctrl::RegisterBlock = 0x400a_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ahb_secure_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AHB_SECURE_CTRL {
    type Target = ahb_secure_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AHB_SECURE_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AHB_SECURE_CTRL").finish()
    }
}
#[doc = "AHB secure controller"]
pub mod ahb_secure_ctrl;
#[doc = "no description available"]
pub struct SCNSCB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SCNSCB {}
impl SCNSCB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const scn_scb::RegisterBlock = 0xe000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const scn_scb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SCNSCB {
    type Target = scn_scb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SCNSCB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SCNSCB").finish()
    }
}
#[doc = "no description available"]
pub mod scn_scb;
#[doc = "no description available"]
pub struct SAU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SAU {}
impl SAU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sau::RegisterBlock = 0xe000_edd0 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sau::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SAU {
    type Target = sau::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SAU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SAU").finish()
    }
}
#[doc = "no description available"]
pub mod sau;
#[doc = "USB1 High-speed Device Controller"]
pub struct USB0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB0 {}
impl USB0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb1::RegisterBlock = 0x4008_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB0 {
    type Target = usb1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB0").finish()
    }
}
#[doc = "NXP ROM patch unit. Undocumented by NXP, this peripheral is experimentally modeled following research by Oxide Computer Company: <https://oxide.computer/blog/lpc55/>."]
pub struct RPU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RPU {}
impl RPU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rpu::RegisterBlock = 0x4003_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rpu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RPU {
    type Target = rpu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RPU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RPU").finish()
    }
}
#[doc = "NXP ROM patch unit. Undocumented by NXP, this peripheral is experimentally modeled following research by Oxide Computer Company: <https://oxide.computer/blog/lpc55/>."]
pub mod rpu;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "FLASH_CFPA0"]
    pub FLASH_CFPA0: FLASH_CFPA0,
    #[doc = "FLASH_CFPA_SCRATCH"]
    pub FLASH_CFPA_SCRATCH: FLASH_CFPA_SCRATCH,
    #[doc = "FLASH_CFPA1"]
    pub FLASH_CFPA1: FLASH_CFPA1,
    #[doc = "FLASH_CMPA"]
    pub FLASH_CMPA: FLASH_CMPA,
    #[doc = "FLASH_KEY_STORE"]
    pub FLASH_KEY_STORE: FLASH_KEY_STORE,
    #[doc = "SYSCON"]
    pub SYSCON: SYSCON,
    #[doc = "IOCON"]
    pub IOCON: IOCON,
    #[doc = "GINT0"]
    pub GINT0: GINT0,
    #[doc = "GINT1"]
    pub GINT1: GINT1,
    #[doc = "PINT"]
    pub PINT: PINT,
    #[doc = "SECPINT"]
    pub SECPINT: SECPINT,
    #[doc = "INPUTMUX"]
    pub INPUTMUX: INPUTMUX,
    #[doc = "CTIMER0"]
    pub CTIMER0: CTIMER0,
    #[doc = "CTIMER1"]
    pub CTIMER1: CTIMER1,
    #[doc = "CTIMER2"]
    pub CTIMER2: CTIMER2,
    #[doc = "CTIMER3"]
    pub CTIMER3: CTIMER3,
    #[doc = "CTIMER4"]
    pub CTIMER4: CTIMER4,
    #[doc = "WWDT"]
    pub WWDT: WWDT,
    #[doc = "MRT0"]
    pub MRT0: MRT0,
    #[doc = "UTICK0"]
    pub UTICK0: UTICK0,
    #[doc = "ANACTRL"]
    pub ANACTRL: ANACTRL,
    #[doc = "PMC"]
    pub PMC: PMC,
    #[doc = "SYSCTL"]
    pub SYSCTL: SYSCTL,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "OSTIMER"]
    pub OSTIMER: OSTIMER,
    #[doc = "FLASH"]
    pub FLASH: FLASH,
    #[doc = "PRINCE"]
    pub PRINCE: PRINCE,
    #[doc = "USBPHY"]
    pub USBPHY: USBPHY,
    #[doc = "RNG"]
    pub RNG: RNG,
    #[doc = "PUF"]
    pub PUF: PUF,
    #[doc = "PLU"]
    pub PLU: PLU,
    #[doc = "DMA0"]
    pub DMA0: DMA0,
    #[doc = "DMA1"]
    pub DMA1: DMA1,
    #[doc = "SCT0"]
    pub SCT0: SCT0,
    #[doc = "FLEXCOMM0"]
    pub FLEXCOMM0: FLEXCOMM0,
    #[doc = "FLEXCOMM1"]
    pub FLEXCOMM1: FLEXCOMM1,
    #[doc = "FLEXCOMM2"]
    pub FLEXCOMM2: FLEXCOMM2,
    #[doc = "FLEXCOMM3"]
    pub FLEXCOMM3: FLEXCOMM3,
    #[doc = "FLEXCOMM4"]
    pub FLEXCOMM4: FLEXCOMM4,
    #[doc = "FLEXCOMM5"]
    pub FLEXCOMM5: FLEXCOMM5,
    #[doc = "FLEXCOMM6"]
    pub FLEXCOMM6: FLEXCOMM6,
    #[doc = "FLEXCOMM7"]
    pub FLEXCOMM7: FLEXCOMM7,
    #[doc = "FLEXCOMM8"]
    pub FLEXCOMM8: FLEXCOMM8,
    #[doc = "I2C0"]
    pub I2C0: I2C0,
    #[doc = "I2C1"]
    pub I2C1: I2C1,
    #[doc = "I2C2"]
    pub I2C2: I2C2,
    #[doc = "I2C3"]
    pub I2C3: I2C3,
    #[doc = "I2C4"]
    pub I2C4: I2C4,
    #[doc = "I2C5"]
    pub I2C5: I2C5,
    #[doc = "I2C6"]
    pub I2C6: I2C6,
    #[doc = "I2C7"]
    pub I2C7: I2C7,
    #[doc = "I2S0"]
    pub I2S0: I2S0,
    #[doc = "I2S1"]
    pub I2S1: I2S1,
    #[doc = "I2S2"]
    pub I2S2: I2S2,
    #[doc = "I2S3"]
    pub I2S3: I2S3,
    #[doc = "I2S4"]
    pub I2S4: I2S4,
    #[doc = "I2S5"]
    pub I2S5: I2S5,
    #[doc = "I2S6"]
    pub I2S6: I2S6,
    #[doc = "I2S7"]
    pub I2S7: I2S7,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI1"]
    pub SPI1: SPI1,
    #[doc = "SPI2"]
    pub SPI2: SPI2,
    #[doc = "SPI3"]
    pub SPI3: SPI3,
    #[doc = "SPI4"]
    pub SPI4: SPI4,
    #[doc = "SPI5"]
    pub SPI5: SPI5,
    #[doc = "SPI6"]
    pub SPI6: SPI6,
    #[doc = "SPI7"]
    pub SPI7: SPI7,
    #[doc = "SPI8"]
    pub SPI8: SPI8,
    #[doc = "USART0"]
    pub USART0: USART0,
    #[doc = "USART1"]
    pub USART1: USART1,
    #[doc = "USART2"]
    pub USART2: USART2,
    #[doc = "USART3"]
    pub USART3: USART3,
    #[doc = "USART4"]
    pub USART4: USART4,
    #[doc = "USART5"]
    pub USART5: USART5,
    #[doc = "USART6"]
    pub USART6: USART6,
    #[doc = "USART7"]
    pub USART7: USART7,
    #[doc = "MAILBOX"]
    pub MAILBOX: MAILBOX,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "USB1"]
    pub USB1: USB1,
    #[doc = "CRC_ENGINE"]
    pub CRC_ENGINE: CRC_ENGINE,
    #[doc = "SDIF"]
    pub SDIF: SDIF,
    #[doc = "DBGMAILBOX"]
    pub DBGMAILBOX: DBGMAILBOX,
    #[doc = "ADC0"]
    pub ADC0: ADC0,
    #[doc = "USBFSH"]
    pub USBFSH: USBFSH,
    #[doc = "USBHSH"]
    pub USBHSH: USBHSH,
    #[doc = "HASHCRYPT"]
    pub HASHCRYPT: HASHCRYPT,
    #[doc = "CASPER"]
    pub CASPER: CASPER,
    #[doc = "POWERQUAD"]
    pub POWERQUAD: POWERQUAD,
    #[doc = "SECGPIO"]
    pub SECGPIO: SECGPIO,
    #[doc = "AHB_SECURE_CTRL"]
    pub AHB_SECURE_CTRL: AHB_SECURE_CTRL,
    #[doc = "SCNSCB"]
    pub SCNSCB: SCNSCB,
    #[doc = "SAU"]
    pub SAU: SAU,
    #[doc = "USB0"]
    pub USB0: USB0,
    #[doc = "RPU"]
    pub RPU: RPU,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            FLASH_CFPA0: FLASH_CFPA0 {
                _marker: PhantomData,
            },
            FLASH_CFPA_SCRATCH: FLASH_CFPA_SCRATCH {
                _marker: PhantomData,
            },
            FLASH_CFPA1: FLASH_CFPA1 {
                _marker: PhantomData,
            },
            FLASH_CMPA: FLASH_CMPA {
                _marker: PhantomData,
            },
            FLASH_KEY_STORE: FLASH_KEY_STORE {
                _marker: PhantomData,
            },
            SYSCON: SYSCON {
                _marker: PhantomData,
            },
            IOCON: IOCON {
                _marker: PhantomData,
            },
            GINT0: GINT0 {
                _marker: PhantomData,
            },
            GINT1: GINT1 {
                _marker: PhantomData,
            },
            PINT: PINT {
                _marker: PhantomData,
            },
            SECPINT: SECPINT {
                _marker: PhantomData,
            },
            INPUTMUX: INPUTMUX {
                _marker: PhantomData,
            },
            CTIMER0: CTIMER0 {
                _marker: PhantomData,
            },
            CTIMER1: CTIMER1 {
                _marker: PhantomData,
            },
            CTIMER2: CTIMER2 {
                _marker: PhantomData,
            },
            CTIMER3: CTIMER3 {
                _marker: PhantomData,
            },
            CTIMER4: CTIMER4 {
                _marker: PhantomData,
            },
            WWDT: WWDT {
                _marker: PhantomData,
            },
            MRT0: MRT0 {
                _marker: PhantomData,
            },
            UTICK0: UTICK0 {
                _marker: PhantomData,
            },
            ANACTRL: ANACTRL {
                _marker: PhantomData,
            },
            PMC: PMC {
                _marker: PhantomData,
            },
            SYSCTL: SYSCTL {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            OSTIMER: OSTIMER {
                _marker: PhantomData,
            },
            FLASH: FLASH {
                _marker: PhantomData,
            },
            PRINCE: PRINCE {
                _marker: PhantomData,
            },
            USBPHY: USBPHY {
                _marker: PhantomData,
            },
            RNG: RNG {
                _marker: PhantomData,
            },
            PUF: PUF {
                _marker: PhantomData,
            },
            PLU: PLU {
                _marker: PhantomData,
            },
            DMA0: DMA0 {
                _marker: PhantomData,
            },
            DMA1: DMA1 {
                _marker: PhantomData,
            },
            SCT0: SCT0 {
                _marker: PhantomData,
            },
            FLEXCOMM0: FLEXCOMM0 {
                _marker: PhantomData,
            },
            FLEXCOMM1: FLEXCOMM1 {
                _marker: PhantomData,
            },
            FLEXCOMM2: FLEXCOMM2 {
                _marker: PhantomData,
            },
            FLEXCOMM3: FLEXCOMM3 {
                _marker: PhantomData,
            },
            FLEXCOMM4: FLEXCOMM4 {
                _marker: PhantomData,
            },
            FLEXCOMM5: FLEXCOMM5 {
                _marker: PhantomData,
            },
            FLEXCOMM6: FLEXCOMM6 {
                _marker: PhantomData,
            },
            FLEXCOMM7: FLEXCOMM7 {
                _marker: PhantomData,
            },
            FLEXCOMM8: FLEXCOMM8 {
                _marker: PhantomData,
            },
            I2C0: I2C0 {
                _marker: PhantomData,
            },
            I2C1: I2C1 {
                _marker: PhantomData,
            },
            I2C2: I2C2 {
                _marker: PhantomData,
            },
            I2C3: I2C3 {
                _marker: PhantomData,
            },
            I2C4: I2C4 {
                _marker: PhantomData,
            },
            I2C5: I2C5 {
                _marker: PhantomData,
            },
            I2C6: I2C6 {
                _marker: PhantomData,
            },
            I2C7: I2C7 {
                _marker: PhantomData,
            },
            I2S0: I2S0 {
                _marker: PhantomData,
            },
            I2S1: I2S1 {
                _marker: PhantomData,
            },
            I2S2: I2S2 {
                _marker: PhantomData,
            },
            I2S3: I2S3 {
                _marker: PhantomData,
            },
            I2S4: I2S4 {
                _marker: PhantomData,
            },
            I2S5: I2S5 {
                _marker: PhantomData,
            },
            I2S6: I2S6 {
                _marker: PhantomData,
            },
            I2S7: I2S7 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI1: SPI1 {
                _marker: PhantomData,
            },
            SPI2: SPI2 {
                _marker: PhantomData,
            },
            SPI3: SPI3 {
                _marker: PhantomData,
            },
            SPI4: SPI4 {
                _marker: PhantomData,
            },
            SPI5: SPI5 {
                _marker: PhantomData,
            },
            SPI6: SPI6 {
                _marker: PhantomData,
            },
            SPI7: SPI7 {
                _marker: PhantomData,
            },
            SPI8: SPI8 {
                _marker: PhantomData,
            },
            USART0: USART0 {
                _marker: PhantomData,
            },
            USART1: USART1 {
                _marker: PhantomData,
            },
            USART2: USART2 {
                _marker: PhantomData,
            },
            USART3: USART3 {
                _marker: PhantomData,
            },
            USART4: USART4 {
                _marker: PhantomData,
            },
            USART5: USART5 {
                _marker: PhantomData,
            },
            USART6: USART6 {
                _marker: PhantomData,
            },
            USART7: USART7 {
                _marker: PhantomData,
            },
            MAILBOX: MAILBOX {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            USB1: USB1 {
                _marker: PhantomData,
            },
            CRC_ENGINE: CRC_ENGINE {
                _marker: PhantomData,
            },
            SDIF: SDIF {
                _marker: PhantomData,
            },
            DBGMAILBOX: DBGMAILBOX {
                _marker: PhantomData,
            },
            ADC0: ADC0 {
                _marker: PhantomData,
            },
            USBFSH: USBFSH {
                _marker: PhantomData,
            },
            USBHSH: USBHSH {
                _marker: PhantomData,
            },
            HASHCRYPT: HASHCRYPT {
                _marker: PhantomData,
            },
            CASPER: CASPER {
                _marker: PhantomData,
            },
            POWERQUAD: POWERQUAD {
                _marker: PhantomData,
            },
            SECGPIO: SECGPIO {
                _marker: PhantomData,
            },
            AHB_SECURE_CTRL: AHB_SECURE_CTRL {
                _marker: PhantomData,
            },
            SCNSCB: SCNSCB {
                _marker: PhantomData,
            },
            SAU: SAU {
                _marker: PhantomData,
            },
            USB0: USB0 {
                _marker: PhantomData,
            },
            RPU: RPU {
                _marker: PhantomData,
            },
        }
    }
}
