#![doc = "Peripheral access API for LPC54605 microcontrollers (generated using svd2rust v0.21.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.21.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[cfg(feature = "rt")]
extern "C" {
    fn WDT_BOD();
    fn DMA0();
    fn GINT0();
    fn GINT1();
    fn PIN_INT0();
    fn PIN_INT1();
    fn PIN_INT2();
    fn PIN_INT3();
    fn UTICK0();
    fn MRT0();
    fn CTIMER0();
    fn CTIMER1();
    fn SCT0();
    fn CTIMER3();
    fn FLEXCOMM0();
    fn FLEXCOMM1();
    fn FLEXCOMM2();
    fn FLEXCOMM3();
    fn FLEXCOMM4();
    fn FLEXCOMM5();
    fn FLEXCOMM6();
    fn FLEXCOMM7();
    fn ADC0_SEQA();
    fn ADC0_SEQB();
    fn ADC0_THCMP();
    fn DMIC0();
    fn HWVAD0();
    fn USB0_NEEDCLK();
    fn USB0();
    fn RTC();
    fn PIN_INT4();
    fn PIN_INT5();
    fn PIN_INT6();
    fn PIN_INT7();
    fn CTIMER2();
    fn CTIMER4();
    fn RIT();
    fn SPIFI0();
    fn FLEXCOMM8();
    fn FLEXCOMM9();
    fn SDIO();
    fn USB1();
    fn USB1_NEEDCLK();
    fn EEPROM();
    fn SMARTCARD0();
    fn SMARTCARD1();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 57] = [
    Vector { _handler: WDT_BOD },
    Vector { _handler: DMA0 },
    Vector { _handler: GINT0 },
    Vector { _handler: GINT1 },
    Vector { _handler: PIN_INT0 },
    Vector { _handler: PIN_INT1 },
    Vector { _handler: PIN_INT2 },
    Vector { _handler: PIN_INT3 },
    Vector { _handler: UTICK0 },
    Vector { _handler: MRT0 },
    Vector { _handler: CTIMER0 },
    Vector { _handler: CTIMER1 },
    Vector { _handler: SCT0 },
    Vector { _handler: CTIMER3 },
    Vector {
        _handler: FLEXCOMM0,
    },
    Vector {
        _handler: FLEXCOMM1,
    },
    Vector {
        _handler: FLEXCOMM2,
    },
    Vector {
        _handler: FLEXCOMM3,
    },
    Vector {
        _handler: FLEXCOMM4,
    },
    Vector {
        _handler: FLEXCOMM5,
    },
    Vector {
        _handler: FLEXCOMM6,
    },
    Vector {
        _handler: FLEXCOMM7,
    },
    Vector {
        _handler: ADC0_SEQA,
    },
    Vector {
        _handler: ADC0_SEQB,
    },
    Vector {
        _handler: ADC0_THCMP,
    },
    Vector { _handler: DMIC0 },
    Vector { _handler: HWVAD0 },
    Vector {
        _handler: USB0_NEEDCLK,
    },
    Vector { _handler: USB0 },
    Vector { _handler: RTC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: PIN_INT4 },
    Vector { _handler: PIN_INT5 },
    Vector { _handler: PIN_INT6 },
    Vector { _handler: PIN_INT7 },
    Vector { _handler: CTIMER2 },
    Vector { _handler: CTIMER4 },
    Vector { _handler: RIT },
    Vector { _handler: SPIFI0 },
    Vector {
        _handler: FLEXCOMM8,
    },
    Vector {
        _handler: FLEXCOMM9,
    },
    Vector { _handler: SDIO },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: USB1 },
    Vector {
        _handler: USB1_NEEDCLK,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: EEPROM },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: SMARTCARD0,
    },
    Vector {
        _handler: SMARTCARD1,
    },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - WDT_BOD"]
    WDT_BOD = 0,
    #[doc = "1 - DMA0"]
    DMA0 = 1,
    #[doc = "2 - GINT0"]
    GINT0 = 2,
    #[doc = "3 - GINT1"]
    GINT1 = 3,
    #[doc = "4 - PIN_INT0"]
    PIN_INT0 = 4,
    #[doc = "5 - PIN_INT1"]
    PIN_INT1 = 5,
    #[doc = "6 - PIN_INT2"]
    PIN_INT2 = 6,
    #[doc = "7 - PIN_INT3"]
    PIN_INT3 = 7,
    #[doc = "8 - UTICK0"]
    UTICK0 = 8,
    #[doc = "9 - MRT0"]
    MRT0 = 9,
    #[doc = "10 - CTIMER0"]
    CTIMER0 = 10,
    #[doc = "11 - CTIMER1"]
    CTIMER1 = 11,
    #[doc = "12 - SCT0"]
    SCT0 = 12,
    #[doc = "13 - CTIMER3"]
    CTIMER3 = 13,
    #[doc = "14 - FLEXCOMM0"]
    FLEXCOMM0 = 14,
    #[doc = "15 - FLEXCOMM1"]
    FLEXCOMM1 = 15,
    #[doc = "16 - FLEXCOMM2"]
    FLEXCOMM2 = 16,
    #[doc = "17 - FLEXCOMM3"]
    FLEXCOMM3 = 17,
    #[doc = "18 - FLEXCOMM4"]
    FLEXCOMM4 = 18,
    #[doc = "19 - FLEXCOMM5"]
    FLEXCOMM5 = 19,
    #[doc = "20 - FLEXCOMM6"]
    FLEXCOMM6 = 20,
    #[doc = "21 - FLEXCOMM7"]
    FLEXCOMM7 = 21,
    #[doc = "22 - ADC0_SEQA"]
    ADC0_SEQA = 22,
    #[doc = "23 - ADC0_SEQB"]
    ADC0_SEQB = 23,
    #[doc = "24 - ADC0_THCMP"]
    ADC0_THCMP = 24,
    #[doc = "25 - DMIC0"]
    DMIC0 = 25,
    #[doc = "26 - HWVAD0"]
    HWVAD0 = 26,
    #[doc = "27 - USB0_NEEDCLK"]
    USB0_NEEDCLK = 27,
    #[doc = "28 - USB0"]
    USB0 = 28,
    #[doc = "29 - RTC"]
    RTC = 29,
    #[doc = "32 - PIN_INT4"]
    PIN_INT4 = 32,
    #[doc = "33 - PIN_INT5"]
    PIN_INT5 = 33,
    #[doc = "34 - PIN_INT6"]
    PIN_INT6 = 34,
    #[doc = "35 - PIN_INT7"]
    PIN_INT7 = 35,
    #[doc = "36 - CTIMER2"]
    CTIMER2 = 36,
    #[doc = "37 - CTIMER4"]
    CTIMER4 = 37,
    #[doc = "38 - RIT"]
    RIT = 38,
    #[doc = "39 - SPIFI0"]
    SPIFI0 = 39,
    #[doc = "40 - FLEXCOMM8"]
    FLEXCOMM8 = 40,
    #[doc = "41 - FLEXCOMM9"]
    FLEXCOMM9 = 41,
    #[doc = "42 - SDIO"]
    SDIO = 42,
    #[doc = "47 - USB1"]
    USB1 = 47,
    #[doc = "48 - USB1_NEEDCLK"]
    USB1_NEEDCLK = 48,
    #[doc = "52 - EEPROM"]
    EEPROM = 52,
    #[doc = "55 - SMARTCARD0"]
    SMARTCARD0 = 55,
    #[doc = "56 - SMARTCARD1"]
    SMARTCARD1 = 56,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "LPC5460x System configuration (SYSCON)"]
pub struct SYSCON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCON {}
impl SYSCON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const syscon::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const syscon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCON {
    type Target = syscon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCON").finish()
    }
}
#[doc = "LPC5460x System configuration (SYSCON)"]
pub mod syscon;
#[doc = "LPC5411x I/O pin configuration (IOCON)"]
pub struct IOCON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOCON {}
impl IOCON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const iocon::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const iocon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOCON {
    type Target = iocon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOCON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOCON").finish()
    }
}
#[doc = "LPC5411x I/O pin configuration (IOCON)"]
pub mod iocon;
#[doc = "LPC5411x Group GPIO input interrupt (GINT0/1)"]
pub struct GINT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GINT0 {}
impl GINT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gint0::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gint0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GINT0 {
    type Target = gint0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GINT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GINT0").finish()
    }
}
#[doc = "LPC5411x Group GPIO input interrupt (GINT0/1)"]
pub mod gint0;
#[doc = "LPC5411x Group GPIO input interrupt (GINT0/1)"]
pub struct GINT1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GINT1 {}
impl GINT1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gint0::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gint0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GINT1 {
    type Target = gint0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GINT1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GINT1").finish()
    }
}
#[doc = "LPC5411x Group GPIO input interrupt (GINT0/1)"]
pub use gint0 as gint1;
#[doc = "LPC5411x Pin interrupt and pattern match (PINT)"]
pub struct PINT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PINT {}
impl PINT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pint::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pint::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PINT {
    type Target = pint::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PINT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PINT").finish()
    }
}
#[doc = "LPC5411x Pin interrupt and pattern match (PINT)"]
pub mod pint;
#[doc = "LPC5411x Input multiplexing (INPUT MUX)"]
pub struct INPUTMUX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for INPUTMUX {}
impl INPUTMUX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const inputmux::RegisterBlock = 0x4000_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const inputmux::RegisterBlock {
        Self::PTR
    }
}
impl Deref for INPUTMUX {
    type Target = inputmux::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for INPUTMUX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("INPUTMUX").finish()
    }
}
#[doc = "LPC5411x Input multiplexing (INPUT MUX)"]
pub mod inputmux;
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER0 {}
impl CTIMER0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER0 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER0").finish()
    }
}
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub mod ctimer0;
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER1 {}
impl CTIMER1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER1 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER1").finish()
    }
}
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub use ctimer0 as ctimer1;
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER2 {}
impl CTIMER2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER2 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER2").finish()
    }
}
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub use ctimer0 as ctimer2;
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER3 {}
impl CTIMER3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4004_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER3 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER3").finish()
    }
}
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub use ctimer0 as ctimer3;
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub struct CTIMER4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CTIMER4 {}
impl CTIMER4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ctimer0::RegisterBlock = 0x4004_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ctimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CTIMER4 {
    type Target = ctimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CTIMER4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CTIMER4").finish()
    }
}
#[doc = "LPC5411x Standard counter/timers (CTIMER0 to 4)"]
pub use ctimer0 as ctimer4;
#[doc = "LPC5411x Windowed Watchdog Timer (WWDT)"]
pub struct WWDT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WWDT {}
impl WWDT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wwdt::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wwdt::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WWDT {
    type Target = wwdt::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WWDT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WWDT").finish()
    }
}
#[doc = "LPC5411x Windowed Watchdog Timer (WWDT)"]
pub mod wwdt;
#[doc = "LPC5411x Multi-Rate Timer (MRT)"]
pub struct MRT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MRT0 {}
impl MRT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mrt0::RegisterBlock = 0x4000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mrt0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MRT0 {
    type Target = mrt0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MRT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MRT0").finish()
    }
}
#[doc = "LPC5411x Multi-Rate Timer (MRT)"]
pub mod mrt0;
#[doc = "LPC5411x Micro-tick Timer (UTICK)"]
pub struct UTICK0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UTICK0 {}
impl UTICK0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const utick0::RegisterBlock = 0x4000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const utick0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UTICK0 {
    type Target = utick0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UTICK0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UTICK0").finish()
    }
}
#[doc = "LPC5411x Micro-tick Timer (UTICK)"]
pub mod utick0;
#[doc = "LPC5460x EEPROM controller"]
pub struct EEPROM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EEPROM {}
impl EEPROM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const eeprom::RegisterBlock = 0x4001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const eeprom::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EEPROM {
    type Target = eeprom::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EEPROM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EEPROM").finish()
    }
}
#[doc = "LPC5460x EEPROM controller"]
pub mod eeprom;
#[doc = "This is the description of component otpc It is an eFUSE OTP (One Time Programmable memory) controller with APB bus interface. More details will follow."]
pub struct OTPC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OTPC {}
impl OTPC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const otpc::RegisterBlock = 0x4001_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const otpc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OTPC {
    type Target = otpc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OTPC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OTPC").finish()
    }
}
#[doc = "This is the description of component otpc It is an eFUSE OTP (One Time Programmable memory) controller with APB bus interface. More details will follow."]
pub mod otpc;
#[doc = "LPC5411x Real-Time Clock (RTC)"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x4002_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "LPC5411x Real-Time Clock (RTC)"]
pub mod rtc;
#[doc = "LPC5460x Repetitive Interrupt Timer(RIT)"]
pub struct RIT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RIT {}
impl RIT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rit::RegisterBlock = 0x4002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rit::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RIT {
    type Target = rit::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RIT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RIT").finish()
    }
}
#[doc = "LPC5460x Repetitive Interrupt Timer(RIT)"]
pub mod rit;
#[doc = "LPC5460x Flash signature generator"]
pub struct FMC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FMC {}
impl FMC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const fmc::RegisterBlock = 0x4003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const fmc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FMC {
    type Target = fmc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FMC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FMC").finish()
    }
}
#[doc = "LPC5460x Flash signature generator"]
pub mod fmc;
#[doc = "LPC5460x Smart Card Interface"]
pub struct SMARTCARD0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMARTCARD0 {}
impl SMARTCARD0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smartcard0::RegisterBlock = 0x4003_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smartcard0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMARTCARD0 {
    type Target = smartcard0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMARTCARD0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMARTCARD0").finish()
    }
}
#[doc = "LPC5460x Smart Card Interface"]
pub mod smartcard0;
#[doc = "LPC5460x Smart Card Interface"]
pub struct SMARTCARD1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMARTCARD1 {}
impl SMARTCARD1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smartcard0::RegisterBlock = 0x4003_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smartcard0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMARTCARD1 {
    type Target = smartcard0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMARTCARD1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMARTCARD1").finish()
    }
}
#[doc = "LPC5460x Smart Card Interface"]
pub use smartcard0 as smartcard1;
#[doc = "LPC5411x Asynchronous system configuration (ASYNC_SYSCON)"]
pub struct ASYNC_SYSCON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ASYNC_SYSCON {}
impl ASYNC_SYSCON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const async_syscon::RegisterBlock = 0x4004_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const async_syscon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ASYNC_SYSCON {
    type Target = async_syscon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ASYNC_SYSCON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ASYNC_SYSCON").finish()
    }
}
#[doc = "LPC5411x Asynchronous system configuration (ASYNC_SYSCON)"]
pub mod async_syscon;
#[doc = "LPC5411x SPI Flash Interface (SPIFI)"]
pub struct SPIFI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIFI0 {}
impl SPIFI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spifi0::RegisterBlock = 0x4008_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spifi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIFI0 {
    type Target = spifi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIFI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIFI0").finish()
    }
}
#[doc = "LPC5411x SPI Flash Interface (SPIFI)"]
pub mod spifi0;
#[doc = "LPC5460x External Memory Controller (EMC)"]
pub struct EMC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EMC {}
impl EMC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const emc::RegisterBlock = 0x4008_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const emc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EMC {
    type Target = emc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EMC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EMC").finish()
    }
}
#[doc = "LPC5460x External Memory Controller (EMC)"]
pub mod emc;
#[doc = "LPC5411x DMA controller"]
pub struct DMA0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA0 {}
impl DMA0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma0::RegisterBlock = 0x4008_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA0 {
    type Target = dma0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA0").finish()
    }
}
#[doc = "LPC5411x DMA controller"]
pub mod dma0;
#[doc = "LPC5411x USB 2.0 Device Controller"]
pub struct USB0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB0 {}
impl USB0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb0::RegisterBlock = 0x4008_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB0 {
    type Target = usb0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB0").finish()
    }
}
#[doc = "LPC5411x USB 2.0 Device Controller"]
pub mod usb0;
#[doc = "SCTimer/PWM (SCT)"]
pub struct SCT0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SCT0 {}
impl SCT0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sct0::RegisterBlock = 0x4008_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sct0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SCT0 {
    type Target = sct0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SCT0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SCT0").finish()
    }
}
#[doc = "SCTimer/PWM (SCT)"]
pub mod sct0;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM0 {}
impl FLEXCOMM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM0 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM0").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub mod flexcomm0;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM1 {}
impl FLEXCOMM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM1 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM1").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm1;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM2 {}
impl FLEXCOMM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM2 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM2").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm2;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM3 {}
impl FLEXCOMM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM3 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM3").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm3;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM4 {}
impl FLEXCOMM4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM4 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM4").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm4;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM5 {}
impl FLEXCOMM5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM5 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM5").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm5;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM6 {}
impl FLEXCOMM6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM6 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM6").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm6;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM7 {}
impl FLEXCOMM7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM7 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM7").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm7;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM8 {}
impl FLEXCOMM8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM8 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM8").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm8;
#[doc = "LPC5411x Flexcomm serial communication"]
pub struct FLEXCOMM9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLEXCOMM9 {}
impl FLEXCOMM9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flexcomm0::RegisterBlock = 0x4009_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flexcomm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLEXCOMM9 {
    type Target = flexcomm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLEXCOMM9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLEXCOMM9").finish()
    }
}
#[doc = "LPC5411x Flexcomm serial communication"]
pub use flexcomm0 as flexcomm9;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C0 {}
impl I2C0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C0 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C0").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub mod i2c0;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C1 {}
impl I2C1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C1 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C1").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c1;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C2 {}
impl I2C2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C2 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C2").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c2;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C3 {}
impl I2C3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C3 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C3").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c3;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C4 {}
impl I2C4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C4 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C4").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c4;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C5 {}
impl I2C5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C5 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C5").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c5;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C6 {}
impl I2C6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C6 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C6").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c6;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C7 {}
impl I2C7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C7 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C7").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c7;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C8 {}
impl I2C8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C8 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C8").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c8;
#[doc = "LPC5411x I2C-bus interfaces"]
pub struct I2C9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C9 {}
impl I2C9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4009_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C9 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C9").finish()
    }
}
#[doc = "LPC5411x I2C-bus interfaces"]
pub use i2c0 as i2c9;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub mod spi0;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI1 {}
impl SPI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI1 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI1").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi1;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI2 {}
impl SPI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI2 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI2").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi2;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI3 {}
impl SPI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI3 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI3").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi3;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI4 {}
impl SPI4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI4 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI4").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi4;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI5 {}
impl SPI5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI5 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI5").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi5;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI6 {}
impl SPI6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI6 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI6").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi6;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI7 {}
impl SPI7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI7 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI7").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi7;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI8 {}
impl SPI8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI8 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI8").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi8;
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub struct SPI9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI9 {}
impl SPI9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4009_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI9 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI9").finish()
    }
}
#[doc = "LPC5411x Serial Peripheral Interfaces (SPI)"]
pub use spi0 as spi9;
#[doc = "LPC5411x USARTs"]
pub struct USART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART0 {}
impl USART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART0 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART0").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub mod usart0;
#[doc = "LPC5411x USARTs"]
pub struct USART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART1 {}
impl USART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART1 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART1").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart1;
#[doc = "LPC5411x USARTs"]
pub struct USART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART2 {}
impl USART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART2 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART2").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart2;
#[doc = "LPC5411x USARTs"]
pub struct USART3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART3 {}
impl USART3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART3 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART3").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart3;
#[doc = "LPC5411x USARTs"]
pub struct USART4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART4 {}
impl USART4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4008_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART4 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART4").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart4;
#[doc = "LPC5411x USARTs"]
pub struct USART5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART5 {}
impl USART5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART5 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART5").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart5;
#[doc = "LPC5411x USARTs"]
pub struct USART6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART6 {}
impl USART6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART6 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART6").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart6;
#[doc = "LPC5411x USARTs"]
pub struct USART7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART7 {}
impl USART7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART7 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART7").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart7;
#[doc = "LPC5411x USARTs"]
pub struct USART8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART8 {}
impl USART8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART8 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART8").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart8;
#[doc = "LPC5411x USARTs"]
pub struct USART9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USART9 {}
impl USART9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usart0::RegisterBlock = 0x4009_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USART9 {
    type Target = usart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USART9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USART9").finish()
    }
}
#[doc = "LPC5411x USARTs"]
pub use usart0 as usart9;
#[doc = "LPC5411x General Purpose I/O (GPIO)"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x4008_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "LPC5411x General Purpose I/O (GPIO)"]
pub mod gpio;
#[doc = "LPC5411x DMIC Subsystem (DMIC))"]
pub struct DMIC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMIC0 {}
impl DMIC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dmic0::RegisterBlock = 0x4009_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dmic0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMIC0 {
    type Target = dmic0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMIC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMIC0").finish()
    }
}
#[doc = "LPC5411x DMIC Subsystem (DMIC))"]
pub mod dmic0;
#[doc = "LPC5460x USB1 High-speed Device Controller"]
pub struct USBHSD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBHSD {}
impl USBHSD {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbhsd::RegisterBlock = 0x4009_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbhsd::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBHSD {
    type Target = usbhsd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBHSD {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBHSD").finish()
    }
}
#[doc = "LPC5460x USB1 High-speed Device Controller"]
pub mod usbhsd;
#[doc = "LPC5411x CRC engine"]
pub struct CRC_ENGINE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRC_ENGINE {}
impl CRC_ENGINE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crc_engine::RegisterBlock = 0x4009_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crc_engine::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRC_ENGINE {
    type Target = crc_engine::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRC_ENGINE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRC_ENGINE").finish()
    }
}
#[doc = "LPC5411x CRC engine"]
pub mod crc_engine;
#[doc = "LPC5411x I2S interface"]
pub struct I2S0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S0 {}
impl I2S0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4009_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S0 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S0").finish()
    }
}
#[doc = "LPC5411x I2S interface"]
pub mod i2s0;
#[doc = "LPC5411x I2S interface"]
pub struct I2S1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S1 {}
impl I2S1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x4009_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S1 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S1").finish()
    }
}
#[doc = "LPC5411x I2S interface"]
pub use i2s0 as i2s1;
#[doc = "SDMMC"]
pub struct SDIF {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SDIF {}
impl SDIF {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sdif::RegisterBlock = 0x4009_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sdif::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SDIF {
    type Target = sdif::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SDIF {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SDIF").finish()
    }
}
#[doc = "SDMMC"]
pub mod sdif;
#[doc = "LPC5411x 12-bit ADC controller (ADC)"]
pub struct ADC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC0 {}
impl ADC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc0::RegisterBlock = 0x400a_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC0 {
    type Target = adc0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC0").finish()
    }
}
#[doc = "LPC5411x 12-bit ADC controller (ADC)"]
pub mod adc0;
#[doc = "LPC5460x USB0 Full-speed Host controller"]
pub struct USBFSH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBFSH {}
impl USBFSH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbfsh::RegisterBlock = 0x400a_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbfsh::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBFSH {
    type Target = usbfsh::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBFSH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBFSH").finish()
    }
}
#[doc = "LPC5460x USB0 Full-speed Host controller"]
pub mod usbfsh;
#[doc = "LPC5460x USB1 High-speed Host Controller"]
pub struct USBHSH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USBHSH {}
impl USBHSH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usbhsh::RegisterBlock = 0x400a_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usbhsh::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USBHSH {
    type Target = usbhsh::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USBHSH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USBHSH").finish()
    }
}
#[doc = "LPC5460x USB1 High-speed Host Controller"]
pub mod usbhsh;
#[doc = "System Control Block"]
pub struct SYSTEMCONTROL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTEMCONTROL {}
impl SYSTEMCONTROL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const system_control::RegisterBlock = 0xe000_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const system_control::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTEMCONTROL {
    type Target = system_control::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTEMCONTROL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTEMCONTROL").finish()
    }
}
#[doc = "System Control Block"]
pub mod system_control;
#[doc = "System timer"]
pub struct SYSTICK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTICK {}
impl SYSTICK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_tick::RegisterBlock = 0xe000_e010 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_tick::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTICK {
    type Target = sys_tick::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTICK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTICK").finish()
    }
}
#[doc = "System timer"]
pub mod sys_tick;
#[doc = "Embedded Trace Macrocell Registers"]
pub struct ETM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ETM {}
impl ETM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const etm::RegisterBlock = 0xe004_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const etm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ETM {
    type Target = etm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ETM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ETM").finish()
    }
}
#[doc = "Embedded Trace Macrocell Registers"]
pub mod etm;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "SYSCON"]
    pub SYSCON: SYSCON,
    #[doc = "IOCON"]
    pub IOCON: IOCON,
    #[doc = "GINT0"]
    pub GINT0: GINT0,
    #[doc = "GINT1"]
    pub GINT1: GINT1,
    #[doc = "PINT"]
    pub PINT: PINT,
    #[doc = "INPUTMUX"]
    pub INPUTMUX: INPUTMUX,
    #[doc = "CTIMER0"]
    pub CTIMER0: CTIMER0,
    #[doc = "CTIMER1"]
    pub CTIMER1: CTIMER1,
    #[doc = "CTIMER2"]
    pub CTIMER2: CTIMER2,
    #[doc = "CTIMER3"]
    pub CTIMER3: CTIMER3,
    #[doc = "CTIMER4"]
    pub CTIMER4: CTIMER4,
    #[doc = "WWDT"]
    pub WWDT: WWDT,
    #[doc = "MRT0"]
    pub MRT0: MRT0,
    #[doc = "UTICK0"]
    pub UTICK0: UTICK0,
    #[doc = "EEPROM"]
    pub EEPROM: EEPROM,
    #[doc = "OTPC"]
    pub OTPC: OTPC,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "RIT"]
    pub RIT: RIT,
    #[doc = "FMC"]
    pub FMC: FMC,
    #[doc = "SMARTCARD0"]
    pub SMARTCARD0: SMARTCARD0,
    #[doc = "SMARTCARD1"]
    pub SMARTCARD1: SMARTCARD1,
    #[doc = "ASYNC_SYSCON"]
    pub ASYNC_SYSCON: ASYNC_SYSCON,
    #[doc = "SPIFI0"]
    pub SPIFI0: SPIFI0,
    #[doc = "EMC"]
    pub EMC: EMC,
    #[doc = "DMA0"]
    pub DMA0: DMA0,
    #[doc = "USB0"]
    pub USB0: USB0,
    #[doc = "SCT0"]
    pub SCT0: SCT0,
    #[doc = "FLEXCOMM0"]
    pub FLEXCOMM0: FLEXCOMM0,
    #[doc = "FLEXCOMM1"]
    pub FLEXCOMM1: FLEXCOMM1,
    #[doc = "FLEXCOMM2"]
    pub FLEXCOMM2: FLEXCOMM2,
    #[doc = "FLEXCOMM3"]
    pub FLEXCOMM3: FLEXCOMM3,
    #[doc = "FLEXCOMM4"]
    pub FLEXCOMM4: FLEXCOMM4,
    #[doc = "FLEXCOMM5"]
    pub FLEXCOMM5: FLEXCOMM5,
    #[doc = "FLEXCOMM6"]
    pub FLEXCOMM6: FLEXCOMM6,
    #[doc = "FLEXCOMM7"]
    pub FLEXCOMM7: FLEXCOMM7,
    #[doc = "FLEXCOMM8"]
    pub FLEXCOMM8: FLEXCOMM8,
    #[doc = "FLEXCOMM9"]
    pub FLEXCOMM9: FLEXCOMM9,
    #[doc = "I2C0"]
    pub I2C0: I2C0,
    #[doc = "I2C1"]
    pub I2C1: I2C1,
    #[doc = "I2C2"]
    pub I2C2: I2C2,
    #[doc = "I2C3"]
    pub I2C3: I2C3,
    #[doc = "I2C4"]
    pub I2C4: I2C4,
    #[doc = "I2C5"]
    pub I2C5: I2C5,
    #[doc = "I2C6"]
    pub I2C6: I2C6,
    #[doc = "I2C7"]
    pub I2C7: I2C7,
    #[doc = "I2C8"]
    pub I2C8: I2C8,
    #[doc = "I2C9"]
    pub I2C9: I2C9,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI1"]
    pub SPI1: SPI1,
    #[doc = "SPI2"]
    pub SPI2: SPI2,
    #[doc = "SPI3"]
    pub SPI3: SPI3,
    #[doc = "SPI4"]
    pub SPI4: SPI4,
    #[doc = "SPI5"]
    pub SPI5: SPI5,
    #[doc = "SPI6"]
    pub SPI6: SPI6,
    #[doc = "SPI7"]
    pub SPI7: SPI7,
    #[doc = "SPI8"]
    pub SPI8: SPI8,
    #[doc = "SPI9"]
    pub SPI9: SPI9,
    #[doc = "USART0"]
    pub USART0: USART0,
    #[doc = "USART1"]
    pub USART1: USART1,
    #[doc = "USART2"]
    pub USART2: USART2,
    #[doc = "USART3"]
    pub USART3: USART3,
    #[doc = "USART4"]
    pub USART4: USART4,
    #[doc = "USART5"]
    pub USART5: USART5,
    #[doc = "USART6"]
    pub USART6: USART6,
    #[doc = "USART7"]
    pub USART7: USART7,
    #[doc = "USART8"]
    pub USART8: USART8,
    #[doc = "USART9"]
    pub USART9: USART9,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "DMIC0"]
    pub DMIC0: DMIC0,
    #[doc = "USBHSD"]
    pub USBHSD: USBHSD,
    #[doc = "CRC_ENGINE"]
    pub CRC_ENGINE: CRC_ENGINE,
    #[doc = "I2S0"]
    pub I2S0: I2S0,
    #[doc = "I2S1"]
    pub I2S1: I2S1,
    #[doc = "SDIF"]
    pub SDIF: SDIF,
    #[doc = "ADC0"]
    pub ADC0: ADC0,
    #[doc = "USBFSH"]
    pub USBFSH: USBFSH,
    #[doc = "USBHSH"]
    pub USBHSH: USBHSH,
    #[doc = "SYSTEMCONTROL"]
    pub SYSTEMCONTROL: SYSTEMCONTROL,
    #[doc = "SYSTICK"]
    pub SYSTICK: SYSTICK,
    #[doc = "ETM"]
    pub ETM: ETM,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            SYSCON: SYSCON {
                _marker: PhantomData,
            },
            IOCON: IOCON {
                _marker: PhantomData,
            },
            GINT0: GINT0 {
                _marker: PhantomData,
            },
            GINT1: GINT1 {
                _marker: PhantomData,
            },
            PINT: PINT {
                _marker: PhantomData,
            },
            INPUTMUX: INPUTMUX {
                _marker: PhantomData,
            },
            CTIMER0: CTIMER0 {
                _marker: PhantomData,
            },
            CTIMER1: CTIMER1 {
                _marker: PhantomData,
            },
            CTIMER2: CTIMER2 {
                _marker: PhantomData,
            },
            CTIMER3: CTIMER3 {
                _marker: PhantomData,
            },
            CTIMER4: CTIMER4 {
                _marker: PhantomData,
            },
            WWDT: WWDT {
                _marker: PhantomData,
            },
            MRT0: MRT0 {
                _marker: PhantomData,
            },
            UTICK0: UTICK0 {
                _marker: PhantomData,
            },
            EEPROM: EEPROM {
                _marker: PhantomData,
            },
            OTPC: OTPC {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            RIT: RIT {
                _marker: PhantomData,
            },
            FMC: FMC {
                _marker: PhantomData,
            },
            SMARTCARD0: SMARTCARD0 {
                _marker: PhantomData,
            },
            SMARTCARD1: SMARTCARD1 {
                _marker: PhantomData,
            },
            ASYNC_SYSCON: ASYNC_SYSCON {
                _marker: PhantomData,
            },
            SPIFI0: SPIFI0 {
                _marker: PhantomData,
            },
            EMC: EMC {
                _marker: PhantomData,
            },
            DMA0: DMA0 {
                _marker: PhantomData,
            },
            USB0: USB0 {
                _marker: PhantomData,
            },
            SCT0: SCT0 {
                _marker: PhantomData,
            },
            FLEXCOMM0: FLEXCOMM0 {
                _marker: PhantomData,
            },
            FLEXCOMM1: FLEXCOMM1 {
                _marker: PhantomData,
            },
            FLEXCOMM2: FLEXCOMM2 {
                _marker: PhantomData,
            },
            FLEXCOMM3: FLEXCOMM3 {
                _marker: PhantomData,
            },
            FLEXCOMM4: FLEXCOMM4 {
                _marker: PhantomData,
            },
            FLEXCOMM5: FLEXCOMM5 {
                _marker: PhantomData,
            },
            FLEXCOMM6: FLEXCOMM6 {
                _marker: PhantomData,
            },
            FLEXCOMM7: FLEXCOMM7 {
                _marker: PhantomData,
            },
            FLEXCOMM8: FLEXCOMM8 {
                _marker: PhantomData,
            },
            FLEXCOMM9: FLEXCOMM9 {
                _marker: PhantomData,
            },
            I2C0: I2C0 {
                _marker: PhantomData,
            },
            I2C1: I2C1 {
                _marker: PhantomData,
            },
            I2C2: I2C2 {
                _marker: PhantomData,
            },
            I2C3: I2C3 {
                _marker: PhantomData,
            },
            I2C4: I2C4 {
                _marker: PhantomData,
            },
            I2C5: I2C5 {
                _marker: PhantomData,
            },
            I2C6: I2C6 {
                _marker: PhantomData,
            },
            I2C7: I2C7 {
                _marker: PhantomData,
            },
            I2C8: I2C8 {
                _marker: PhantomData,
            },
            I2C9: I2C9 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI1: SPI1 {
                _marker: PhantomData,
            },
            SPI2: SPI2 {
                _marker: PhantomData,
            },
            SPI3: SPI3 {
                _marker: PhantomData,
            },
            SPI4: SPI4 {
                _marker: PhantomData,
            },
            SPI5: SPI5 {
                _marker: PhantomData,
            },
            SPI6: SPI6 {
                _marker: PhantomData,
            },
            SPI7: SPI7 {
                _marker: PhantomData,
            },
            SPI8: SPI8 {
                _marker: PhantomData,
            },
            SPI9: SPI9 {
                _marker: PhantomData,
            },
            USART0: USART0 {
                _marker: PhantomData,
            },
            USART1: USART1 {
                _marker: PhantomData,
            },
            USART2: USART2 {
                _marker: PhantomData,
            },
            USART3: USART3 {
                _marker: PhantomData,
            },
            USART4: USART4 {
                _marker: PhantomData,
            },
            USART5: USART5 {
                _marker: PhantomData,
            },
            USART6: USART6 {
                _marker: PhantomData,
            },
            USART7: USART7 {
                _marker: PhantomData,
            },
            USART8: USART8 {
                _marker: PhantomData,
            },
            USART9: USART9 {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            DMIC0: DMIC0 {
                _marker: PhantomData,
            },
            USBHSD: USBHSD {
                _marker: PhantomData,
            },
            CRC_ENGINE: CRC_ENGINE {
                _marker: PhantomData,
            },
            I2S0: I2S0 {
                _marker: PhantomData,
            },
            I2S1: I2S1 {
                _marker: PhantomData,
            },
            SDIF: SDIF {
                _marker: PhantomData,
            },
            ADC0: ADC0 {
                _marker: PhantomData,
            },
            USBFSH: USBFSH {
                _marker: PhantomData,
            },
            USBHSH: USBHSH {
                _marker: PhantomData,
            },
            SYSTEMCONTROL: SYSTEMCONTROL {
                _marker: PhantomData,
            },
            SYSTICK: SYSTICK {
                _marker: PhantomData,
            },
            ETM: ETM {
                _marker: PhantomData,
            },
        }
    }
}
