# lpc546xx-pac
This crate provides an autogenerated API for access to LPC546XX-PAC peripherals.
The API is generated using [svd2rust] with patched svd files containing
extensive type-safe support. For more information please see the [main repo].
Refer to the [documentation] for full details.
[svd2rust]: https://github.com/rust-embedded/svd2rust
[main repo]: https://github.com/lpc-rs/lpc-pac
[documentation]: https://docs.rs/lpc546xx-pac/latest/lpc546xx-pac/
## Usage
Each device supported by this crate is behind a feature gate so that you only
compile the device(s) you want. To use, in your Cargo.toml:
```toml
[dependencies.lpc546xx-pac]
version = "0.2.0"
features = ["lpc54605"]
```
The `rt` feature is enabled by default and brings in support for `cortex-m-rt`.
To disable, specify `default-features = false` in `Cargo.toml`.
In your code:
```rust
use lpc546xx_pac::lpc54605;
let mut peripherals = lpc54605::Peripherals::take().unwrap();
let gpio = &peripherals.gpio;
```
For full details on the autogenerated API, please see:
https://docs.rs/svd2rust/0.21.0/svd2rust/#peripheral-api
## Supported Devices
| Module | Devices | Links |
|:------:|:-------:|:-----:|
| lpc546xx-pac | lpc54605, lpc54606, lpc54607, lpc54608, lpc54616, lpc54618, lpc54628 | [UM10912](https://www.nxp.com/webapp/Download?colCode=UM10912), [nxp.com](https://www.nxp.com/products/processors-and-microcontrollers/arm-microcontrollers/general-purpose-mcus/lpc54000-cortex-m4-/power-efficient-microcontrollers-mcus-with-advanced-peripherals-based-on-arm-cortex-m4-core:LPC546XX) |
