# lpc546xx-pac [![crates.io](https://img.shields.io/crates/v/lpc546xx-pac.svg)](https://crates.io/crates/lpc546xx-pac) [![Documentation](https://docs.rs/lpc546xx-pac/badge.svg)](https://docs.rs/lpc546xx-pac) [![Build Status](https://travis-ci.com/lpc-rs/lpc-pac.svg?branch=master)](https://travis-ci.com/lpc-rs/lpc-pac)

## Introduction

Low-level register mappings for the [NXP LPC546xx] family of ARM Cortex-M4 microcontrollers, written in [Rust]. The code is generated automatically from the SVD file in this directory, using [svd2rust].

The purpose of this crate is to give embedded programs or libraries written Rust access to the complete functionality of LPC546xx MCUs.


## Usage

Add this to the `[dependencies]` section of your `Cargo.toml` to include LPC546xx PAC in your Cargo project:

``` toml
lpc546xx-pac = {version = "0.1.0", features = ["lpc54608"]}
```

This crate includes an optional `rt` feature that can be activated by adding this instead:

``` toml
lpc546xx-pac = { version = "0.1.0", features = ["lpc54608","rt"] }
```

The `rt` feature includes the [cortex-m-rt] crate and provides overridable interrupt handlers. Please refer to the [svd2rust documentation] for further details.

## Documentation

For specific information on the API, check out the **[API reference]**.

All code in this crate is automatically generated by [svd2rust], so check out the **[svd2rust documentation]** for more general information about how the API works.

In addition, the LPC546xx user manual (avaible through the NXP website) contains extensive documentation on how to work with the microcontroller.


[Rust]: https://www.rust-lang.org/
[NXP LPC546xx]: https://www.nxp.com/products/processors-and-microcontrollers/arm-microcontrollers/general-purpose-mcus/lpc54000-cortex-m4-/power-efficient-microcontrollers-mcus-with-advanced-peripherals-based-on-arm-cortex-m4-core:LPC546XX
[svd2rust]: https://crates.io/crates/svd2rust
[cortex-m-rt]: https://crates.io/crates/cortex-m-rt
[svd2rust documentation]: https://docs.rs/svd2rust
[API reference]: https://docs.rs/lpc54607-pac
[open an issue]: https://github.com/lpc-rs/lpc-pac/issues/new
[list of open issues]: https://github.com/lpc-rs/lpc-pac/issues
[rustup]: https://rustup.rs/


