#[doc = "Register `EPINUSE` reader"]
pub struct R(crate::pac::generic::R<EPINUSE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::pac::generic::R<EPINUSE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::pac::generic::R<EPINUSE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::pac::generic::R<EPINUSE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EPINUSE` writer"]
pub struct W(crate::pac::generic::W<EPINUSE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::pac::generic::W<EPINUSE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::pac::generic::W<EPINUSE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::pac::generic::W<EPINUSE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BUF` reader - Buffer in use: This register has one bit per physical endpoint. 0: HW is accessing buffer 0. 1: HW is accessing buffer 1."]
pub struct BUF_R(crate::pac::generic::FieldReader<u8, u8>);
impl BUF_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BUF_R(crate::pac::generic::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUF_R {
    type Target = crate::pac::generic::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUF` writer - Buffer in use: This register has one bit per physical endpoint. 0: HW is accessing buffer 0. 1: HW is accessing buffer 1."]
pub struct BUF_W<'a> {
    w: &'a mut W,
}
impl<'a> BUF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 2)) | ((value as u32 & 0xff) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bits 2:9 - Buffer in use: This register has one bit per physical endpoint. 0: HW is accessing buffer 0. 1: HW is accessing buffer 1."]
    #[inline(always)]
    pub fn buf(&self) -> BUF_R {
        BUF_R::new(((self.bits >> 2) & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 2:9 - Buffer in use: This register has one bit per physical endpoint. 0: HW is accessing buffer 0. 1: HW is accessing buffer 1."]
    #[inline(always)]
    pub fn buf(&mut self) -> BUF_W {
        BUF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Endpoint Buffer in use\n\nThis register you can [`read`](crate::pac::generic::generic::Reg::read), [`write_with_zero`](crate::pac::generic::generic::Reg::write_with_zero), [`reset`](crate::pac::generic::generic::Reg::reset), [`write`](crate::pac::generic::generic::Reg::write), [`modify`](crate::pac::generic::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [epinuse](index.html) module"]
pub struct EPINUSE_SPEC;
impl crate::pac::generic::RegisterSpec for EPINUSE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [epinuse::R](R) reader structure"]
impl crate::pac::generic::Readable for EPINUSE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [epinuse::W](W) writer structure"]
impl crate::pac::generic::Writable for EPINUSE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EPINUSE to value 0"]
impl crate::pac::generic::Resettable for EPINUSE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
