
//! ` students.txt ` should be a UTF-8 plain-text file, and each name of students to lottery should in a line.
//! 
//! > This project was written for my chemistry teacher, albeit he didn't use this tool ever.
//! > As a result I found he didn't really want to use it, he was only joking.
//! > However this project could be generally used. Please don't expect code quality...

#![feature(proc_macro_hygiene, decl_macro)]
#![feature(option_result_unwrap_unchecked)]
#[macro_use] extern crate rocket;

use rand::prelude::SliceRandom;
use rocket::response::content;
use std::path::PathBuf;
use lazy_static::lazy_static;
use rocket_contrib::serve::StaticFiles;

lazy_static! {
    static ref STUDENTS: Vec<String> = {
        let students = std::fs::read_to_string(PathBuf::from("students.txt"))
            .expect("Cannot read student.txt as UTF-8!");
        let students = students.lines().map(|refe| refe.to_owned()).collect();
        students
    };
}

#[get("/rand")]
fn next_result() -> rocket::response::content::Html<String> {
    let result = unsafe {
        STUDENTS.choose(&mut rand::thread_rng()).unwrap_unchecked()
    };
    content::Html(format!(
        r#"
        <html>
            <head>
                <title>抽号</title>
            </head>
            <body>
                <center>
                <h1>{}</h1><br>
                <p>Author: poly000</p>
            </body>
        </html>"#, result ) )
}


fn main() {
    let _ = STUDENTS.len(); // Check students.txt when starts
    rocket::ignite()
        .mount("/", routes![next_result])
        .mount("/", StaticFiles::from("index"))
        .launch();
}
