use colored::Colorize;
use std::env;
use std::process;

use lolgrep::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    let seprator = "<------------------------------------------->"
        .green()
        .bold();

    println!(
        "{}\nSearching for '{}' in '{}'\n{}",
        seprator,
        config.query.bold().italic().green(),
        config.filename.bold().italic().green(),
        seprator
    );

    if let Err(e) = lolgrep::run(config) {
        eprintln!("Application error: {}", e);

        process::exit(1);
    }
}
