use colored::Colorize;
use std::env;
use std::process;

use lolgrep::Config;

fn main() {
    let args: Vec<String> = env::args().collect();

    let config = Config::new(&args).unwrap_or_else(|err| {
        println!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    let seprator = "<------------------------------------------->"
        .green()
        .bold();

    println!(
        "{}\nSearching for '{}' in '{}'\n{}",
        seprator,
        config.query.bold().italic().green(),
        config.filename.bold().italic().green(),
        seprator
    );

    if let Err(e) = lolgrep::run(config) {
        println!("Application error: {}", e);

        process::exit(1);
    }
}
