pub fn map_range(from_range: (f64, f64), to_range: (u64, u64), s: f64) -> f64 {
    to_range.0 as f64 + (s - from_range.0) * (to_range.1 as f64 - to_range.0 as f64) / (from_range.1 - from_range.0)
}

#[cfg(test)]
mod tests {
    use crate::map_range;

    #[test]
    fn test_map_range_positive_value() {
        let result = map_range((-1.0, 1.0), (0, 255), 0.2) as usize;

        assert_eq!(result, 153);
    }

    #[test]
    fn test_map_range_negative_value() {
        let result = map_range((-1.0, 1.0), (0, 255), -0.2) as usize;

        assert_eq!(result, 102);
    }
}
