mod prelude {
    pub use crate::Parser;
    pub use nom::bytes::complete::tag;
    pub use nom::combinator::map;
    pub use nom::multi::separated_list1;
    pub use nom::sequence::{delimited, preceded};
    pub use nom::{
        branch::alt,
        character::complete::{char as cchar, digit0, satisfy},
        combinator::{map_res, opt, recognize},
        sequence::{pair, tuple},
        IResult,
    };
    pub use nom::{
        bytes::complete::{take_till, take_until, take_while},
        character::complete::multispace1,
        multi::many1,
    };
    extern crate derive_more;
    pub use derive_more::From;
}

pub mod basic;
pub use basic::*;
pub mod expr;
pub use expr::*;
pub mod metric_expr;
pub use metric_expr::*;
pub mod log_expr;
pub use log_expr::*;
pub mod operator;
pub use operator::*;
pub mod unit;
pub use unit::*;

use nom::IResult;
use prelude::*;
pub trait Parser: Sized {
    fn parse(input: &str) -> IResult<&str, Self>;
}

impl<A, B> Parser for (A, B)
where
    A: Parser,
    B: Parser,
{
    fn parse(input: &str) -> IResult<&str, Self> {
        map(
            tuple((A::parse, opt(Separator::parse), B::parse)),
            |(a, _, b)| (a, b),
        )(input)
    }
}
