use crate::prelude::*;

#[derive(Eq, PartialEq, Debug, Clone)]
pub enum DurationUnit {
    NS,
    US,
    MS,
    S,
    M,
    H,
}

impl Parser for DurationUnit {
    fn parse(input: &str) -> IResult<&str, Self> {
        alt((
            map(tag("ns"), |_| DurationUnit::NS),
            map(tag("us"), |_| DurationUnit::US),
            map(tag("ms"), |_| DurationUnit::MS),
            map(tag("s"), |_| DurationUnit::S),
            map(tag("m"), |_| DurationUnit::M),
            map(tag("h"), |_| DurationUnit::H),
        ))(input)
    }
}

#[derive(Eq, PartialEq, Debug, Clone)]
pub enum BytesUnit {
    B,
    KiB,
    KB,
    MiB,
    MB,
    GiB,
    GB,
    TiB,
    TB,
    PiB,
    PB,
    EiB,
    EB,
}

impl Parser for BytesUnit {
    fn parse(input: &str) -> IResult<&str, Self> {
        alt((
            map(tag("B"), |_| BytesUnit::B),
            map(tag("KiB"), |_| BytesUnit::KiB),
            map(tag("KB"), |_| BytesUnit::KB),
            map(tag("MiB"), |_| BytesUnit::MiB),
            map(tag("MB"), |_| BytesUnit::MB),
            map(tag("GiB"), |_| BytesUnit::GiB),
            map(tag("GB"), |_| BytesUnit::GB),
            map(tag("TiB"), |_| BytesUnit::TiB),
            map(tag("TB"), |_| BytesUnit::TB),
            map(tag("PiB"), |_| BytesUnit::PiB),
            map(tag("PB"), |_| BytesUnit::PB),
            map(tag("EiB"), |_| BytesUnit::EiB),
            map(tag("EB"), |_| BytesUnit::EB),
        ))(input)
    }
}
