pub mod update {
    use fltk_theme::{ThemeType, WidgetTheme};
    use postgres::{Client, Error, NoTls};

    pub fn db_connect() -> String {
        let client = redis::Client::open("redis://127.0.0.1/").unwrap();
        let mut con = client.get_connection().unwrap();
        let y: String = redis::cmd("GET")
            .arg("db_string_connection")
            .query(&mut con)
            .unwrap();
        return y;
    }

    pub fn theme_type() -> Result<(), Error> {
        let mut client = Client::connect(&db_connect(), NoTls)?;
        for row in client
            .query("SELECT theme FROM themes ORDER BY mark DESC LIMIT 1", &[])
            .unwrap()
        {
            let theme: &str = row.get(0);
            if theme == "greybird" {
                let widget_theme = WidgetTheme::new(ThemeType::Greybird);
                widget_theme.apply();
            } else if theme == "metro" {
                let widget_theme = WidgetTheme::new(ThemeType::Metro);
                widget_theme.apply();
            } else if theme == "dark" {
                let widget_theme = WidgetTheme::new(ThemeType::Dark);
                widget_theme.apply();
            }
        }
        Ok(())
    }
}
