pub mod memory {
    extern crate redis;

    pub fn write_projects_list(value: &str) -> redis::RedisResult<()> {
        let client = redis::Client::open("redis://127.0.0.1/")?;
        let mut con = client.get_connection()?;
        let _: () = redis::cmd("SADD")
            .arg("my_projects")
            .arg(value)
            .query(&mut con)?;
        Ok(())
    }

    #[macro_export]
    macro_rules! add_projects_list {
        ($e:expr) => {
            let client = redis::Client::open("redis://127.0.0.1/").unwrap();
            let mut con = client.get_connection().unwrap();
            let x: Vec<String> = redis::cmd("SMEMBERS")
                .arg("my_projects")
                .query(&mut con)
                .unwrap();
            for i in &x {
                println!("{}", i);
                $e.add(i);
            }
        };
    }

    pub fn db_test(
        project_name: &str,
        hostname: &str,
        dbname: &str,
        username: &str,
        password: &str,
    ) -> redis::RedisResult<()> {
        let mut string_connection = String::from("postgresql://");
        string_connection.push_str(username);
        string_connection.push_str(":");
        string_connection.push_str(password);
        string_connection.push_str("@");
        string_connection.push_str(hostname);
        string_connection.push_str("/");
        string_connection.push_str(dbname);
        let client = redis::Client::open("redis://127.0.0.1/")?;
        let mut con = client.get_connection()?;
        let _: () = redis::cmd("SET")
            .arg(project_name)
            .arg(string_connection)
            .query(&mut con)?;
        Ok(())
    }

    pub fn db_test_connect(
        hostname: &str,
        dbname: &str,
        username: &str,
        password: &str,
    ) -> redis::RedisResult<()> {
        let mut string_connection = String::from("postgresql://");
        string_connection.push_str(username);
        string_connection.push_str(":");
        string_connection.push_str(password);
        string_connection.push_str("@");
        string_connection.push_str(hostname);
        string_connection.push_str("/");
        string_connection.push_str(dbname);
        let client = redis::Client::open("redis://127.0.0.1/")?;
        let mut con = client.get_connection()?;
        let _: () = redis::cmd("SET")
            .arg("db_string_connection")
            .arg(string_connection)
            .query(&mut con)?;
        Ok(())
    }
}
