pub mod create {
    #[macro_export]
    macro_rules! add_tree {
        ($e:expr) => {
            pub fn db_connect() -> String {
                let client = redis::Client::open("redis://127.0.0.1/").unwrap();
                let mut con = client.get_connection().unwrap();
                let y: String = redis::cmd("GET")
                    .arg("db_string_connection")
                    .query(&mut con)
                    .unwrap();
                return y
            }
            let mut client = Client::connect(&db_connect(), NoTls).unwrap();
            for row in client
                .query("SELECT new_plc_name FROM plc_list ORDER BY mark", &[])
                .unwrap()
            {
                let new_table_name: &str = row.get(0);
                $e.add(new_table_name);
            }
            for row in client
                .query("SELECT variable FROM var_list ORDER BY mark", &[])
                .unwrap()
            {
                let variable: &str = row.get(0);
                let v: Value = serde_json::from_str(&variable).unwrap();
                let path_plc = v["variable_path"][0].to_string();
                fn rem_first_and_last(value: &str) -> &str {
                    let mut chars = value.chars();
                    chars.next();
                    chars.next_back();
                    chars.as_str()
                }
                let mut path = rem_first_and_last(&path_plc).to_string();
                path.push_str("/");
                let var_path = v["variable_path"][1].to_string();
                let variable_path = rem_first_and_last(&var_path);
                path.push_str(variable_path);
                $e.add(&path);
            }
        };
    }
}
