//! # Lodust - API Documentation
//!
//! Lodust is the Rust version of **Lodash**, which is a modern Javascript utilty library delivering modularity, performance & extras.
//!
//! ## Usage
//!
//! Depend on `lodust` in `Cargo.toml`:
//!
//! ```toml
//! [dependencies]
//! lodust = "0.1.0"
//! ```
//!
//! ## Functions Categorization
//!
//! We follow the flat function structure of **Lodash**, but the functions can be categorized into following areas:
//!
//! | Category     | Description                                                  |
//! |--------------|--------------------------------------------------------------|
//! | `string`     | Utility functions to deal with Strings                       |
//! | `array`      | Utility functions to deal with Arrays (Not yet support)      |
//! | `collection` | Utility functions to deal with Collections (Not yet support) |
//! | `object`     | Utility functions to deal with Objects (Not yet support)     |
//!

mod string;
#[cfg(feature = "string")]
pub use string::*;
