# Qualifiers

Sometimes users may need multiple shared instances of the same type for different purposes. For
example the application may need
different [`ThreadPool`](https://docs.rs/futures/0.3.16/futures/executor/struct.ThreadPool.html):

* A thread pool for UI with a single thread, since OpenGL does not like concurrency.
* A thread pool for general purpose CPU bound tasks, with a thread for each physical core.
* A thread pool for IO bound tasks, with a small amount of threads. It is IO bound so more threads
  won't make it faster
* A thread pool for other blocking tasks with unbounded threads. Most of them will be idling anyway.

They all share the same type/interface, but have different internal characteristics. Trying to bind
them all will cause duplicated binding failures. Furthermore, the user need to be able to specify
which one they want.

## New type idiom

In most cases,
the [new type idiom](https://doc.rust-lang.org/rust-by-example/generics/new_types.html#new-type-idiom)
is preferred. With new types, Lockjaw sees them as unrelated and won't cause duplicated binding
issues. The compiler also provides strong compile time type check to ensure the correct one is used
(an API that do IO work can explicitly ask for the IoThreadPool).

However, the new type idiom does not work with bindings with type generated by Lockjaw such
as [providers](provider.md), [optional bindings](optional.md),
and [multibinding containers](multibindings.md). It may also cause a lot of wrapping/unwrapping when
working with third party libraries.

## Qualifiers

Qualifiers are hints for Lockjaw to give a type different tags, so they can be bound separately.

A qualifier must be declared first using
the [`#[qualifier]`](https://docs.rs/lockjaw/latest/lockjaw/attr.qualifier.html) attribute macro.

```rust,no_run,noplayground
{{#include ../../tests/module_provides_qualifier.rs:decl}}
```

The struct body does not matter and probably should be empty.

Once the qualifier is declared, it can then be used in
the [`#[qualified]`](https://docs.rs/lockjaw/latest/lockjaw/module_attributes/attr.qualified.html)
attribute on a method in a [`#[module]`](https://docs.rs/lockjaw/latest/lockjaw/attr.module.html),
marking the return type as qualified. Lockjaw will treat the bindings as distinct types.

```rust,no_run,noplayground
{{#include ../../tests/module_provides_qualifier.rs:module}}
```

Qualified types can be injected using
the [`#[qualified]`](https://docs.rs/lockjaw/latest/lockjaw/component_attributes/attr.qualified.html)
attribute on the parameter, or the component method.

```rust,no_run,noplayground
{{#include ../../tests/module_provides_qualifier.rs:component}}
```

```rust,no_run,noplayground
{{#include ../../tests/injectable_inject_qualified.rs:qualified}}
```