# Requesting objects

In the last chapter we manually wrote an object factory:

```rust,no_run,noplayground
{{#include ../projects/inject/src/lib.rs:factory}}
```

Now we will ask Lockjaw to automatically generate it. A factory generating objects using a certain
dependency graph is called a `Component` in Dagger terminology.

## Defining the component

```rust,no_run,noplayground
{{#include ../projects/request/src/lib.rs:component}}
```

Comparing to the manual factory there are not a lot of changes. Since Lockjaw Cannot generate the
implementation immediately, we use a `trait` instead of a `struct` as the interface has to be
abstract. The `trait` is then annotated with
the [`#[component]`](https://docs.rs/lockjaw/0.2.0/lockjaw/attr.component.html) attribute that
instructs Lockjaw to generate the implementation. Lockjaw is able to identify
all [`#[inject]`](https://docs.rs/lockjaw/0.2.0/lockjaw/injectable_attributes/attr.inject.html)
bindings automatically.

For every type we wish to be able to directly create from the component, a method returning the type
should be added to the `trait`. Like the manual factory, the method should take `&self` (and nothing
else) so it may further use the component to create the dependencies it needs. The name of the
method does not really matter, but since you are going to call it later you'd probably want
something sensible.

Note that if a type is not directly needed, the `trait` does not need a method for it. For example
while `Bar` needs `Foo`, if we are never going to use `Foo` in `main()` we can delete the
`create_foo()` method. The trait methods does not affect Lockjaw internal generation, it only
declares what needs to be publicly provided.

## Creating and using the component.

Since `create_foo(&self)` is a method, we need to create the component to be able to call it.
Lockjaw generates a static `build()` method on the trait that can be used to create the component.

```rust,no_run,noplayground
{{#include ../projects/request/src/lib.rs:main}}
```

`build()` returns `Box<dyn COMPONENT>`. Most IDE today does not understand symbols generated by
procedural macros, so you might want to manually hint the type in the `let` expression.

Once the component is created, the trait methods can be used to create the objects.

[Source](https://github.com/azureblaze/lockjaw/tree/main/userguide/projects/request/) of this
chapter