Annotates a struct that contains [`modules`](module) instances to be installed in a
[`component`](component) with the `builder_modules` field. If a module contains fields, it cannot be
auto generated and must be explicitly provided to
[`COMPONENT.build()`](component#pub-fn-buildmodules-builder-modules---impl-component)

The annotated struct will become the parameter for
[`COMPONENT.build()`](component#pub-fn-buildmodules-builder-modules---impl-component)

If a module does not contain any field, it can be auto generated by lockjaw, and can be listed in
the `modules` field instead.

```
# #[macro_use] extern crate lockjaw_processor;
# lockjaw::prologue!("src/lib.rs");
struct StringModule {
    string : String
}
#[module]
impl StringModule {
    #[provides]
    pub fn provide_string(&self) -> String {
        self.string.clone()
    }
}

#[builder_modules]
pub struct MyBuilderModules {
    module : crate::StringModule,
}
#[component(builder_modules : crate::MyBuilderModules)]
pub trait MyComponent {
    fn string(&self) -> String;
}

fn main() {
    let component = MyComponent::build(MyBuilderModules{
        module: StringModule{
            string: "foo".to_owned()
        }
    });
    
    assert_eq!("foo", component.string());
}
epilogue!();
```