//! Locker math.
#![deny(clippy::integer_arithmetic)]

use crate::*;
use num_traits::ToPrimitive;

impl LockerParams {
    /// Calculates the amount of voting power an [Escrow] has.
    pub fn calculate_voter_power(&self, escrow: &Escrow, now: i64) -> Option<u64> {
        // invalid argument, should never happen.
        if now == -1 {
            return None;
        }
        if escrow.escrow_started_at == -1 {
            return Some(0);
        }
        if now >= escrow.escrow_ends_at {
            return Some(0);
        }

        let elapsed_seconds = self
            .max_stake_duration
            .checked_sub(escrow.escrow_started_at.to_u64()?)?;
        // elapsed seconds, clamped to the maximum duration
        let relevant_elapsed_seconds = elapsed_seconds.min(self.max_stake_duration);

        let power = escrow
            .amount
            .checked_mul(relevant_elapsed_seconds)?
            .checked_mul(self.max_stake_vote_multiplier)?
            .checked_div(self.max_stake_duration)?;

        Some(power)
    }
}
