import json
from urllib.request import urlopen
from xml.etree import ElementTree


j = json.dumps


WINDOWS_ZONES_URL = "https://raw.githubusercontent.com/unicode-org/cldr/main/common/supplemental/windowsZones.xml"
HEADER = (
    "/* do not edit -- this file is auto generated by scripts/make-win-mapping.py */"
)


def download():
    return urlopen(WINDOWS_ZONES_URL).read()


def main():
    root = ElementTree.fromstring(download())
    rv = []
    out = open("src/windows_zones.gen.rs", "w")
    out.write(HEADER + "\n\n")
    out.write("const ZONE_MAPPINGS: &[ZoneMapping] = &[\n")
    for mapping in root.findall("./windowsZones/mapTimezones/mapZone"):
        out.write(
            "    ZoneMapping { windows: %s, territory: %s, iana: &%s },\n"
            % (
                j(mapping.attrib["other"]),
                j(mapping.attrib["territory"]),
                j(mapping.attrib["type"].split()),
            )
        )
    out.write("];\n")


if __name__ == "__main__":
    main()
