use thiserror::Error;

/// For big and small mistakes.
#[derive(Debug, Error)]
pub enum LocaleError {
    #[error("Failed to read sources map")]
    SourceLookupFailed,
    #[error("IoError({0})")]
    IoError(#[from] std::io::Error),
    #[error("Failed to read json file({0})")]
    JsonError(#[from] json::Error),
    #[error("Locale was not present in sources list.")]
    LocaleNotFound,
    #[error("Locale was not present in cache.")]
    CacheExhaustion
}

#[allow(unused)]
pub(crate) type Result<T> = std::result::Result<T, LocaleError>;