import { BoxGeometry, BufferGeometry, SphereGeometry } from "three";

export type Shape =
  | { t: "Sphere"; c: number }
  | { t: "Cuboid"; c: [number, number, number] };

export const shapeInto = (shape: Shape): BufferGeometry => {
  switch (shape.t) {
    case "Sphere":
      return new SphereGeometry(shape.c);
    case "Cuboid":
      return new BoxGeometry(...shape.c.map((v) => v * 2));
  }
};
