use rapier3d::geometry::{Collider, ColliderBuilder, SharedShape};
use rapier3d::math::Real;
use serde::Serialize;

#[derive(Debug, Copy, Clone, Serialize)]
#[serde(tag = "t", content = "c")]
pub enum Shape {
    Sphere(Real),
    Cuboid(Real, Real, Real),
}

impl From<Shape> for SharedShape {
    fn from(shape: Shape) -> Self {
        match shape {
            Shape::Sphere(radius) => SharedShape::ball(radius),
            Shape::Cuboid(x, y, z) => SharedShape::cuboid(x, y, z),
        }
    }
}

impl From<Shape> for Collider {
    fn from(shape: Shape) -> Self {
        ColliderBuilder::new(shape.into()).build()
    }
}
