use crate::Component;
use paperplane::tungstenite::Message;
use serde::Serialize;
use std::convert::TryFrom;

#[derive(Debug, Clone, Serialize)]
#[serde(tag = "t", content = "c")]
pub enum ServerMessage<Custom> {
    Components(Vec<(u128, Component)>),
    Custom(Custom),
}

impl From<Vec<(u128, Component)>> for ServerMessage<()> {
    fn from(list: Vec<(u128, Component)>) -> Self {
        Self::Components(list)
    }
}

impl From<(u128, Vec<Component>)> for ServerMessage<()> {
    fn from((entity, mut list): (u128, Vec<Component>)) -> Self {
        Self::Components(
            list.drain(..)
                .map(|component| (entity, component))
                .collect(),
        )
    }
}

impl<T> TryFrom<&ServerMessage<T>> for Message
where
    T: Serialize,
{
    type Error = serde_json::Error;
    fn try_from(val: &ServerMessage<T>) -> Result<Self, Self::Error> {
        serde_json::to_string(val).map(|s| Message::Text(s))
    }
}
