use crate::{Material, Shape};
use rapier3d::dynamics::{RigidBody, RigidBodyHandle};
use rapier3d::geometry::ColliderHandle;

#[derive(Debug, Clone)]
pub struct Mesh {
    pub shape: Shape,
    pub material: Material,
    pub body: RigidBody,
}

#[derive(Debug, Copy, Clone, PartialEq)]
pub struct MeshHandle {
    pub entity: u128,
    pub body_handle: RigidBodyHandle,
    pub collider_handle: ColliderHandle,
}
