import {
  Material as ThreeMaterial,
  MeshBasicMaterial,
  MeshStandardMaterial,
  MeshToonMaterial,
} from "three";

export type Material =
  | { t: "Basic"; c: number }
  | { t: "Standard"; c: number }
  | { t: "Toon"; c: number };

export const materialInto = (material: Material): ThreeMaterial => {
  switch (material.t) {
    case "Basic":
      return new MeshBasicMaterial({ color: material.c });
    case "Standard":
      return new MeshStandardMaterial({ color: material.c });
    case "Toon":
      return new MeshToonMaterial({ color: material.c });
  }
};
