import { Scene, PerspectiveCamera, WebGLRenderer } from "three";

export class Graphics {
  scene: Scene;
  camera: PerspectiveCamera;
  renderer: WebGLRenderer;

  constructor() {
    this.scene = new Scene();
    this.camera = new PerspectiveCamera(120);
    this.renderer = new WebGLRenderer();
  }

  updateAspectRatio() {
    this.camera.aspect = window.innerWidth / window.innerHeight;
    this.camera.updateProjectionMatrix();
    this.renderer.setSize(window.innerWidth, window.innerHeight);
  }

  mount(parent: HTMLElement) {
    this.updateAspectRatio();
    window.onresize = this.updateAspectRatio.bind(this);
    parent.appendChild(this.renderer.domElement);
  }

  animate() {
    this.renderer.render(this.scene, this.camera);
    requestAnimationFrame(this.animate.bind(this));
  }
}
