use crate::{Material, Shape};
use rapier3d::math::{Isometry, Real};
use serde::Serialize;

#[derive(Debug, Copy, Clone, Serialize)]
#[serde(tag = "t", content = "c")]
pub enum Component {
    Shape(Option<Shape>),
    Material(Material),
    Isometry(Isometry<Real>),
}

impl From<Shape> for Component {
    fn from(shape: Shape) -> Self {
        Self::Shape(Some(shape))
    }
}

impl From<Material> for Component {
    fn from(material: Material) -> Self {
        Self::Material(material)
    }
}

impl From<Isometry<Real>> for Component {
    fn from(isometry: Isometry<Real>) -> Self {
        Self::Isometry(isometry)
    }
}
