import { AmbientLight, DirectionalLight } from "three";
// import { Game } from "lnkit";
import { Game } from "../../src";

import type { Input } from "./input";
import type { Output } from "./output";

const game = new Game<Input>();
game.graphics.camera.position.set(0, 0, 15);

const light = new DirectionalLight();
light.position.set(0, 1, 0.5);
light.castShadow = true;
game.graphics.scene.add(light);
game.graphics.scene.add(new AmbientLight(0x444444));

let player: number | undefined = undefined;

game.onmessage = (output: Output) => {
  switch (output.t) {
    case "Player":
      player = output.c;
      break;
  }
};

game.onchange = (entity, mesh) => {
  if (entity === player && mesh) game.graphics.camera.lookAt(mesh.position);
};

game.connect("ws://localhost:42069");

addEventListener("keydown", ({ keyCode }) => {
  switch (keyCode) {
    case 32:
      return game.send({ t: "Jump" });
    case 37:
      return game.send({ t: "Left", c: true });
    case 38:
      return game.send({ t: "Up", c: true });
    case 39:
      return game.send({ t: "Right", c: true });
    case 40:
      return game.send({ t: "Down", c: true });
  }
});

addEventListener("keyup", ({ keyCode }) => {
  switch (keyCode) {
    case 37:
      return game.send({ t: "Left", c: false });
    case 38:
      return game.send({ t: "Up", c: false });
    case 39:
      return game.send({ t: "Right", c: false });
    case 40:
      return game.send({ t: "Down", c: false });
  }
});
