use lnkit::prelude::*;

#[derive(Debug, Deserialize)]
#[serde(tag = "t", content = "c")]
pub enum Input {
    Jump,
    Left(bool),
    Down(bool),
    Up(bool),
    Right(bool),
}

impl TryFrom<Message> for Input {
    type Error = serde_json::Error;
    fn try_from(msg: Message) -> Result<Self, Self::Error> {
        serde_json::from_slice(&msg.into_data())
    }
}
