# Lnkit

Lnkit is a small "glue" library for making multiplayer 3D games.
It ties together
[`rapier`](https://www.rapier.rs) & [`three.js`](https://threejs.org) with
WebSockets using [`tungstenite`](https://crates.io/crates/tungstenite).

The idea is that `rapier3d` physics engine runs on the server and data is sent
to clients using WebSockets. On the client side WebSocket messages are
manifested into `three.js` objects.

Lnkit currently consists of two packages:
[server](https://crates.io/crates/lnkit) written in Rust &
[client](https://npmjs.com/package/lnkit) written in Typescript.

> The API of this library is currently a little inconvenient but will improve in
> `v0.3` or `v0.4`.

## Installation

To include the server package add the following to `Cargo.toml` dependencies section.

```toml
[dependencies]
...
lnkit = "0.2.1"
```

> Or just add with `cargo add lnkit` ([`cargo-edit`](https://crates.io/crates/cargo-edit))

To include the client package add the following to `package.json` dependencies section.

```json
"dependencies": {
  ...
  "three": "0.x",
  "lnkit": "0.2"
}
```

> Or just add with `yarn add three lnkit` or `npm install three lnkit`

## Examples

Available examples are in the
[`examples`](https://gitlab.com/rasmusmerzin/lnkit/-/blob/master/examples)
directory.

To run examples clone this repository and run the server with
`cargo run --example <example_name` &
client with `yarn parcel examples/<example_name>/index.html`
