use thiserror::Error as ThisError;

#[non_exhaustive]
#[derive(Debug, ThisError)]
pub enum Error {
    #[error("EOF while reading")]
    Eof,
    #[error("invalid length for buffer supplied to cursor")]
    InvalidLength,
    #[error("loss of data with cast")]
    BadCast,
    #[error("invalid read size (zero or too large)")]
    InvalidReadSize,
    #[cfg(any(feature = "vbr", doc))]
    #[error("invalid VBR width (must be > 1 but <= system word width)")]
    InvalidVbrWidth,
    #[error("too little data to service request")]
    Short,
}
