use thiserror::Error as ThisError;

#[derive(Debug, ThisError)]
pub enum Error {
    #[error("unexpected EOF while reading")]
    Eof,
    #[error("invalid read size (zero or too large)")]
    InvalidReadSize,
    #[cfg(any(feature = "vbr", doc))]
    #[error("invalid VBR width (must be > 1 but <= system word width)")]
    InvalidVbrWidth,
}
